# NTHL1-snv-molc - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **NTHL1-snv-molc**

## Example Observation: NTHL1-snv-molc

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Molecular Consequence](StructureDefinition-molecular-consequence.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Molecular Consequence

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-NTHL1-snv-var.md)

> **component****code**:coding HGVS**value**:NM_002528.7:c.728G>A

> **component****code**:Feature Consequence**value**:nonsense codon

> **component****code**:Amino acid change (pHGVS)**value**:NP_002519.2:p.Trp243Ter



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "NTHL1-snv-molc",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "molecular-consequence"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/NTHL1-snv-var"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6"
          }
        ],
        "text" : "coding HGVS"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_002528.7:c.728G>A",
            "display" : "NM_002528.7:c.728G>A"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "feature-consequence"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001587",
            "display" : "stop_gained"
          }
        ],
        "text" : "nonsense codon"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48005-3",
            "display" : "Amino acid change (pHGVS)"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NP_002519.2:p.Trp243Ter",
            "display" : "NP_002519.2:p.Trp243Ter"
          }
        ]
      }
    }
  ]
}

```
