# HaplotypeSet-Clinical-Trial-Example-2of2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **HaplotypeSet-Clinical-Trial-Example-2of2**

## Example Observation: HaplotypeSet-Clinical-Trial-Example-2of2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Haplotype name

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: APOE1

**specimen**: [Specimen: identifier = http://example.org#123; accessionIdentifier = http://example.org#456; status = available; type = Buccal smear sample](Specimen-GenomicSpecimenExample02.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | APOE |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "HaplotypeSet-Clinical-Trial-Example-2of2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84414-2"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
        "code" : "441262",
        "display" : "APOE1"
      }
    ]
  },
  "specimen" : {
    "reference" : "Specimen/GenomicSpecimenExample02"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:613",
            "display" : "APOE"
          }
        ]
      }
    }
  ]
}

```
