# HLA-C-haplotype1 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **HLA-C-haplotype1**

## Example Observation: HLA-C-haplotype1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Haplotype](StructureDefinition-haplotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Haplotype Name

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**issued**: 2023-02-01 00:00:00-0500

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**value**: HLA-C*03:03

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | HLA-C |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "HLA-C-haplotype1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/haplotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84414-2",
        "display" : "Haplotype Name"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "issued" : "2023-02-01T00:00:00-05:00",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.ebi.ac.uk/ipd/imgt/hla",
        "code" : "C*03:03",
        "display" : "HLA-C*03:03"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:4933",
            "display" : "HLA-C"
          }
        ]
      }
    }
  ]
}

```
