# GrouperEx03 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GrouperEx03**

## Example Observation: GrouperEx03

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Final

**category**: Laboratory, Genetics

**code**: Group

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**hasMember**: 

* [NC_000010.10(CYP2C19):g.96521657C=](Observation-Pgx-var-1011.md)
* [NC_000010.10(CYP2C19):g.96522463A=](Observation-Pgx-var-1012.md)
* [NC_000010.10(CYP2C19):g.96535173T=](Observation-Pgx-var-1013.md)
* [NC_000010.10(CYP2C19):g.96535210G=](Observation-Pgx-var-1014.md)
* [NC_000010.10(CYP2C19):g.96540410G>A](Observation-Pgx-var-1015.md)
* [NC_000010.10(CYP2C19):g.96541616G=](Observation-Pgx-var-1016.md)
* [NC_000010.10(CYP2C19):g.96541756T=](Observation-Pgx-var-1017.md)
* [NC_000010.10(CYP2C19):g.96612495C=](Observation-Pgx-var-1018.md)
* [NC_000016.9(VKORC1):g.31096368C>T](Observation-Pgx-var-1019.md)
* [NC_000010.10(CYP2C9):g.96702047C=](Observation-Pgx-var-1020.md)
* [NC_000010.10(CYP2C9):g.96741053A=](Observation-Pgx-var-1021.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "GrouperEx03",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
        "code" : "C43359",
        "display" : "Group"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/Pgx-var-1011",
      "display" : "NC_000010.10(CYP2C19):g.96521657C="
    },
    {
      "reference" : "Observation/Pgx-var-1012",
      "display" : "NC_000010.10(CYP2C19):g.96522463A="
    },
    {
      "reference" : "Observation/Pgx-var-1013",
      "display" : "NC_000010.10(CYP2C19):g.96535173T="
    },
    {
      "reference" : "Observation/Pgx-var-1014",
      "display" : "NC_000010.10(CYP2C19):g.96535210G="
    },
    {
      "reference" : "Observation/Pgx-var-1015",
      "display" : "NC_000010.10(CYP2C19):g.96540410G>A"
    },
    {
      "reference" : "Observation/Pgx-var-1016",
      "display" : "NC_000010.10(CYP2C19):g.96541616G="
    },
    {
      "reference" : "Observation/Pgx-var-1017",
      "display" : "NC_000010.10(CYP2C19):g.96541756T="
    },
    {
      "reference" : "Observation/Pgx-var-1018",
      "display" : "NC_000010.10(CYP2C19):g.96612495C="
    },
    {
      "reference" : "Observation/Pgx-var-1019",
      "display" : "NC_000016.9(VKORC1):g.31096368C>T"
    },
    {
      "reference" : "Observation/Pgx-var-1020",
      "display" : "NC_000010.10(CYP2C9):g.96702047C="
    },
    {
      "reference" : "Observation/Pgx-var-1021",
      "display" : "NC_000010.10(CYP2C9):g.96741053A="
    }
  ]
}

```
