# GrouperEx02 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GrouperEx02**

## Example Observation: GrouperEx02

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**status**: Final

**category**: Laboratory, Genetics

**code**: Group

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**hasMember**: 

* [Observation Genotype display name](Observation-Pgx-geno-1001.md)
* [Observation Genotype display name](Observation-Pgx-geno-1003.md)
* [Observation Genotype display name](Observation-Pgx-geno-1002.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "GrouperEx02",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl",
        "code" : "C43359",
        "display" : "Group"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/Pgx-geno-1001"
    },
    {
      "reference" : "Observation/Pgx-geno-1003"
    },
    {
      "reference" : "Observation/Pgx-geno-1002"
    }
  ]
}

```
