# GenotypeExamplePharmVar - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **GenotypeExamplePharmVar**

## Example Observation: GenotypeExamplePharmVar

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genotype](StructureDefinition-genotype.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genotype display name

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2019-04-01

**performer**: [Organization some lab](Organization-ExampleOrg.md)

**value**: CYP2D6*7.001 / CYP2D6*1.001

**specimen**: [Specimen: status = available; type = Tissue](Specimen-GenomicSpecimenExample01.md)

**derivedFrom**: 

* [Observation Haplotype name](Observation-HaplotypeExamplePharmVar01.md)
* [Observation Haplotype name](Observation-HaplotypeExamplePharmVar02.md)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Gene studied [ID] | CYP2D6 |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "GenotypeExamplePharmVar",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genotype"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "84413-4"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2019-04-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "valueCodeableConcept" : {
    "text" : "CYP2D6*7.001 / CYP2D6*1.001"
  },
  "specimen" : {
    "reference" : "Specimen/GenomicSpecimenExample01"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/HaplotypeExamplePharmVar01"
    },
    {
      "reference" : "Observation/HaplotypeExamplePharmVar02"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:2625",
            "display" : "CYP2D6"
          }
        ]
      }
    }
  ]
}

```
