# EGFR-L858R-therapuDrug2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **EGFR-L858R-therapuDrug2**

## Example Observation: EGFR-L858R-therapuDrug2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Therapeutic Implication

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-EGFR-L858R-var.md)

> **component****code**:Therapeutic Implication**value**:Responsive

> **component****Related artifact**: No display for RelatedArtifact (type: citation; document: )**code**:Level of evidence**value**:Tier I - Level A

> **component****code**:Associated phenotype**value**:Non-small cell lung cancer

> **component****Related artifact**: No display for RelatedArtifact (type: citation; document: )**code**:Medication assessed**value**:Erlotinib

> **component****Related artifact**: No display for RelatedArtifact (type: citation; document: )**code**:Conclusion Text**value**: Non-small cell lung cancer with EGFR L858R mutation is sensitive to erlotinib



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "EGFR-L858R-therapuDrug2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/therapeutic-implication"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "therapeutic-implication"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/EGFR-L858R-var"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "therapeutic-implication",
            "display" : "Therapeutic Implication"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6677-4",
            "display" : "Responsive"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://www.jmdjournal.org/cms/attachment/ee43a71b-81de-4cb3-ac5e-2fb9a7d41491/gr2.jpg"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "93044-6",
            "display" : "Level of evidence"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "Tier I - Level A"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81259-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "254637007",
            "display" : "Non-small cell lung cancer (disorder)"
          }
        ],
        "text" : "Non-small cell lung cancer"
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://www.cancer.net/cancer-types/lung-cancer-non-small-cell/types-treatment"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51963-7",
            "display" : "Medication assessed"
          }
        ]
      },
      "valueCodeableConcept" : {
        "text" : "Erlotinib"
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
          "valueRelatedArtifact" : {
            "type" : "citation",
            "document" : {
              "url" : "https://civicdb.org/evidence/2994/summary"
            }
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "conclusion-string"
          }
        ]
      },
      "valueString" : "Non-small cell lung cancer with EGFR L858R mutation is sensitive to erlotinib"
    }
  ]
}

```
