# ATR-insertion-var - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **ATR-insertion-var**

## Example Observation: ATR-insertion-var

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Genetic variant assessment

**subject**: [Substance Junior Hamsburg (official) Male, DoB: 1987-09-01 ( Medical record number: 1234567 (use: temp, period: 2021-01-01 --> (ongoing)))](Patient-somaticPatient.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**value**: Present

**method**: Sequencing

> **component****code**:Transcript reference sequence [ID]**value**:NM_001184.4

> **component****code**:Allelic read depth**value**: 131 reads per base pair(Details: UCUM code1 = '1')

> **component****code**:DNA change type**value**:insertion

> **component****code**:DNA change (c.HGVS)**value**:NM_001184.4:c.2878_2879insAGTAA

> **component****code**:Gene studied [ID]**value**:ATR

> **component****code**:Genomic alt allele [ID]**value**: TTACT

> **component****code**:Chromosome [Identifier] in Blood or Tissue by Molecular genetics method**value**:Chromosome 3

> **component****code**:Genomic allele start-end**value**: 142269071-142269071

> **component****code**:Genomic reference sequence [ID]**value**:NC_000003.11

> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000003.11:g.142269071_142269072insTTACT

> **component****code**:Genomic source class [Type]**value**:Somatic

> **component****code**:Sample variant allelic frequency [NFr]**value**: 0.075 decimal

> **component****code**:Conclusion Text**value**: Gene: ATR; Exon: 14; Nucleotide: NM_001184.4:c.2878_2879insAGTAA; Genomic Location: NC_000003.11:g.142269071_142269072insTTACT; Amino acid: NP_001175.2:p.R960fs*2; Function: loss; Assessment: Likely Pathogenic; Classification: Tier 2C; Allele Fraction: 5.34% (of 131 reads); Variation: Insertion; Interpretation: The protein encoded by this gene is a serine/threonine kinase and DNA damage sensor, activating cell cycle checkpoint signaling upon DNA stress. The encoded protein can phosphorylate and activate several proteins involved ... more



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ATR-insertion-var",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69548-6"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/somaticPatient"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA9633-4",
        "display" : "Present"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA26398-0",
        "display" : "Sequencing"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_001184.4"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "82121-5"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 131,
        "unit" : "reads per base pair",
        "system" : "http://unitsofmeasure.org",
        "code" : "1"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48019-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0000667",
            "display" : "insertion"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_001184.4:c.2878_2879insAGTAA"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48018-6"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.genenames.org",
            "code" : "HGNC:882",
            "display" : "ATR"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69551-0"
          }
        ]
      },
      "valueString" : "TTACT"
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48000-4"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA21256-5",
            "display" : "Chromosome 3"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81254-5"
          }
        ]
      },
      "valueRange" : {
        "low" : {
          "value" : 142269071
        },
        "high" : {
          "value" : 142269071
        }
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48013-7"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NC_000003.11"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81290-9"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NC_000003.11:g.142269071_142269072insTTACT"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48002-0"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6684-0",
            "display" : "Somatic"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "81258-6"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.075,
        "unit" : "decimal",
        "system" : "http://unitsofmeasure.org"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "conclusion-string"
          }
        ]
      },
      "valueString" : "Gene: ATR; Exon: 14; Nucleotide: NM_001184.4:c.2878_2879insAGTAA; Genomic Location: NC_000003.11:g.142269071_142269072insTTACT; Amino acid: NP_001175.2:p.R960fs*2; Function: loss; Assessment: Likely Pathogenic; Classification: Tier 2C; Allele Fraction: 5.34% (of 131 reads); Variation: Insertion; Interpretation: The protein encoded by this gene is a serine/threonine kinase and DNA damage sensor, activating cell cycle checkpoint signaling upon DNA stress. The encoded protein can phosphorylate and activate several proteins involved ... more"
    }
  ]
}

```
