# ATR-insertion-molc - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **ATR-insertion-molc**

## Example Observation: ATR-insertion-molc

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Molecular Consequence](StructureDefinition-molecular-consequence.md)

**status**: Final

**category**: Laboratory, Genetics

**code**: Molecular Consequence

**subject**: [Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, ))](Patient-CGPatientExample01.md)

**effective**: 2023-02-01

**performer**: [Practitioner Test Dolin](Practitioner-pathologistPractitioner.md)

**derivedFrom**: [Observation Genetic variant assessment](Observation-ATR-insertion-var.md)

> **component****code**:coding HGVS**value**:NM_001184.4:c.2878_2879insAGTAA

> **component****code**:Transcript reference sequence [ID]**value**:NM_001184.4

> **component****code**:Feature Consequence**value**:frameshift_variant

> **component****code**:Functional Effect**value**:loss_of_function_variant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ATR-insertion-molc",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-consequence"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
        "code" : "molecular-consequence"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2023-02-01",
  "performer" : [
    {
      "reference" : "Practitioner/pathologistPractitioner"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "Observation/ATR-insertion-var"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48004-6"
          }
        ],
        "text" : "coding HGVS"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://varnomen.hgvs.org",
            "code" : "NM_001184.4:c.2878_2879insAGTAA",
            "display" : "NM_001184.4:c.2878_2879insAGTAA"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51958-7",
            "display" : "Transcript reference sequence [ID]"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ncbi.nlm.nih.gov/refseq",
            "code" : "NM_001184.4",
            "display" : "NM_001184.4"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "feature-consequence"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO:0001589",
            "display" : "frameshift_variant"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
            "code" : "functional-effect"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.sequenceontology.org",
            "code" : "SO_0002054",
            "display" : "loss_of_function_variant"
          }
        ]
      }
    }
  ]
}

```
