# genomicstudy-trio2 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **genomicstudy-trio2**

## Example GenomicStudy: genomicstudy-trio2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

**identifier**: `http://example.org/identifiers/genomicstudies`/urn:uuid:1111-1111-1111-1113 (use: temp, )

**status**: Available

**type**: Trio Analysis

**subject**: [Child Denovo (official) (no stated gender), DoB Unknown ( Medical record number: 1234-11111 (use: temp, ))](Patient-denovoChild.md)

**startDate**: 2023-10-01

**interpreter**: [Practitioner Jane Doel](Practitioner-practitioner02.md)

**note**: 

> 

De novo mutation study of the patient. The Prenatal Trio Whole Exome Sequencing (Prenatal Trio WES) test is ordered by a physician and must be accompanied with a consent form and detailed clinical information. In general, the test is used when prenatal imaging detects an anomaly that strongly suggests that there is an underlying genetic etiology. Prenatal Trio WES is often considered only after fetal chromosome microarray analysis has been non-diagnostic.


> **analysis****genomeBuild**:GRCh38**instantiatesUri**:[https://pubmed.ncbi.nlm.nih.gov/33927380/](https://pubmed.ncbi.nlm.nih.gov/33927380/)**title**: Parental Sequence Variation Detection Using Next Generation Sequencing**focus**:
* [Father Denovo (official) (no stated gender), DoB Unknown ( Medical record number: 6789-11111 (use: temp, ))](Patient-denovoFather.md)
* [Mother Denovo (official) (no stated gender), DoB Unknown ( Medical record number: 0987-11111 (use: temp, ))](Patient-denovoMother.md)
**date**: 2023-10-01**protocolPerformed**:[Procedure Sequencing of entire coding region of gene (procedure)](Procedure-SequencingProcedure.md)
> **input****file**:[DocumentReference: identifier = http://example.org/identifiers/files#11118; status = current; docStatus = preliminary; description = A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicFileProbandBAM.md)**type**:BAM

> **input****file**:[DocumentReference: identifier = http://example.org/identifiers/files#11125; status = current; docStatus = preliminary; description = A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicFileMotherBAM.md)**type**:BAM

> **input****file**:[DocumentReference: identifier = http://example.org/identifiers/files#11132; status = current; docStatus = preliminary; description = A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicFileFatherBAM.md)**type**:BAM

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **File** | **Type** |
| * | [DocumentReference: identifier = http://example.org/identifiers/files#11150; status = current; docStatus = preliminary; description = A sample Document Reference instance representing a generic genomic file that may ber used as input or output of a genomic analysis pipeline.; securityLabel = Restricted](DocumentReference-genomicFileProbandVCF.md) | VCF |




## Resource Content

```json
{
  "resourceType" : "GenomicStudy",
  "id" : "genomicstudy-trio2",
  "identifier" : [
    {
      "use" : "temp",
      "system" : "http://example.org/identifiers/genomicstudies",
      "value" : "urn:uuid:1111-1111-1111-1113"
    }
  ],
  "status" : "available",
  "type" : [
    {
      "text" : "Trio Analysis"
    }
  ],
  "subject" : {
    "reference" : "Patient/denovoChild"
  },
  "startDate" : "2023-10-01",
  "interpreter" : [
    {
      "reference" : "Practitioner/practitioner02"
    }
  ],
  "note" : [
    {
      "text" : "De novo mutation study of the patient. The Prenatal Trio Whole Exome Sequencing (Prenatal Trio WES) test is ordered by a physician and must be accompanied with a consent form and detailed clinical information. In general, the test is used when prenatal imaging detects an anomaly that strongly suggests that there is an underlying genetic etiology. Prenatal Trio WES is often considered only after fetal chromosome microarray analysis has been non-diagnostic."
    }
  ],
  "analysis" : [
    {
      "genomeBuild" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA26806-2",
            "display" : "GRCh38"
          }
        ]
      },
      "instantiatesUri" : "https://pubmed.ncbi.nlm.nih.gov/33927380/",
      "title" : "Parental Sequence Variation Detection Using Next Generation Sequencing",
      "focus" : [
        {
          "reference" : "Patient/denovoFather"
        },
        {
          "reference" : "Patient/denovoMother"
        }
      ],
      "date" : "2023-10-01",
      "protocolPerformed" : {
        "reference" : "Procedure/SequencingProcedure"
      },
      "input" : [
        {
          "file" : {
            "reference" : "DocumentReference/genomicFileProbandBAM"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "bam",
                "display" : "BAM"
              }
            ]
          }
        },
        {
          "file" : {
            "reference" : "DocumentReference/genomicFileMotherBAM"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "bam",
                "display" : "BAM"
              }
            ]
          }
        },
        {
          "file" : {
            "reference" : "DocumentReference/genomicFileFatherBAM"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "bam",
                "display" : "BAM"
              }
            ]
          }
        }
      ],
      "output" : [
        {
          "file" : {
            "reference" : "DocumentReference/genomicFileProbandVCF"
          },
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/genomicstudy-dataformat",
                "code" : "vcf",
                "display" : "VCF"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
