# somaticVCFfile - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **somaticVCFfile**

## Example DocumentReference: somaticVCFfile

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/1134121

**status**: Current

**docStatus**: Preliminary

**description**: 

VCF file containing identified variants

**securityLabel**: Restricted

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **Url** | **Title** |
| * | [https://chat.fhir.org/user_uploads/10155/Rp_GBGx6jz5reuS_Py7XQDjr/somaticVCFFile.vcf](https://chat.fhir.org/user_uploads/10155/Rp_GBGx6jz5reuS_Py7XQDjr/somaticVCFFile.vcf) | somatic VCF File |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "somaticVCFfile",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "1134121"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "VCF file containing identified variants",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/Rp_GBGx6jz5reuS_Py7XQDjr/somaticVCFFile.vcf",
        "title" : "somatic VCF File"
      }
    }
  ]
}

```
