# FullGenome-GRCh38 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **FullGenome-GRCh38**

## Example DocumentReference: FullGenome-GRCh38

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Data File](StructureDefinition-genomic-data-file.md)

**identifier**: `http://example.org/identifiers/files`/1076146520

**status**: Current

**docStatus**: Preliminary

**description**: 

Studied region for RNA sequencing.

**securityLabel**: Restricted

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **Url** | **Title** |
| * | [https://chat.fhir.org/user_uploads/10155/ha97JexWz8T5PLHl7zoLsosd/Default.WGS.GRCh38.bed](https://chat.fhir.org/user_uploads/10155/ha97JexWz8T5PLHl7zoLsosd/Default.WGS.GRCh38.bed) | Full Genome |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "FullGenome-GRCh38",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-data-file"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers/files",
      "value" : "1076146520"
    }
  ],
  "status" : "current",
  "docStatus" : "preliminary",
  "description" : "Studied region for RNA sequencing.",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "Restricted"
        }
      ]
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "https://chat.fhir.org/user_uploads/10155/ha97JexWz8T5PLHl7zoLsosd/Default.WGS.GRCh38.bed",
        "title" : "Full Genome"
      }
    }
  ]
}

```
