# diagnosticreport-hla-glstring-r4 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **diagnosticreport-hla-glstring-r4**

## Example DiagnosticReport: diagnosticreport-hla-glstring-r4

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Anonymous Patient (no stated gender), DoB Unknown |
| When For | 2023-06-01 |
| Performer | [Organization Some lab](Organization-ExampleLab.md) |

**Report Details**

* **Code**: [Genotype display name](Observation-genotype-hla-a-glstring-r4.md)
  * **Value**: hla#3.31.0#HLA-A*03:01:01:01+HLA-A*30:01:01
  * **Flags**: Final
  * **When For**: 2018-07-26
* **Code**: [Haplotype name](Observation-haplotype-hla-a-1-r4.md)
  * **Value**: HLA-A*03:01:01:01
  * **Flags**: Final
  * **When For**: 2018-07-26



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "diagnosticreport-hla-glstring-r4",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
    ]
  },
  "basedOn" : [
    {
      "reference" : "ServiceRequest/servicerequest-hla-a-r4"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE",
          "display" : "Genetics"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51969-4",
        "display" : "Genetic analysis report"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExamplePatient"
  },
  "effectiveDateTime" : "2023-06-01",
  "performer" : [
    {
      "reference" : "Organization/ExampleLab"
    }
  ],
  "specimen" : [
    {
      "reference" : "Specimen/specimen-hla-r4"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/genotype-hla-a-glstring-r4"
    },
    {
      "reference" : "Observation/haplotype-hla-a-1-r4"
    }
  ]
}

```
