# PGxGenomicReportEMERGE - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **PGxGenomicReportEMERGE**

## Example DiagnosticReport: PGxGenomicReportEMERGE

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Adam B. Everyman Male, DoB: 1951-01-20 ( Medical Record Number: m123 (use: usual, )) |
| When For | 2020-01-01 00:00:00-0500 |
| Reported | 2020-01-01 00:00:00-0500 |
| Performer | [Organization some lab](Organization-ExampleOrg.md) |

**Report Details**

* **Code**: [Therapeutic Implication](Observation-TxImp01.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Therapeutic Implication](Observation-TxImp02.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Therapeutic Implication](Observation-TxImp03.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Therapeutic Implication](Observation-TxImp04.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Therapeutic Implication](Observation-TxImp05.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Therapeutic Implication](Observation-TxImp06.md)
  * **Value**: 
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genotype display name](Observation-Pgx-geno-1001.md)
  * **Value**: CYP2C19*2/*2
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genotype display name](Observation-Pgx-geno-1003.md)
  * **Value**: VKORC1 rs9923231 C/T
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genotype display name](Observation-Pgx-geno-1002.md)
  * **Value**: CYP2C9*1/*1
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1011.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2020-01-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1012.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1013.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1014.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1015.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1016.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1017.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1018.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: 
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1019.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: > This variant was confirmed with SANGER sequencing
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1020.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: > This variant was confirmed with SANGER sequencing
  * **When For**: 2019-04-01
* **Code**: [Genetic variant assessment](Observation-Pgx-var-1021.md)
  * **Value**: Present
  * **Flags**: Final
  * **Note**: > This variant was confirmed with SANGER sequencing
  * **When For**: 2019-04-01

Based on the genotype result, this patient is predicted to have a CYP2C19 poor metabolizer phenotype. This genotype information can be used by patients and clinicians as part of the shared decision-making process for several drugs metabolized by CYP2C19 including clopidogrel, voriconazole, amitriptyline, citalopram and escitalopram.

**Coded Conclusions:**

* Positive



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "PGxGenomicReportEMERGE",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx01",
        "display" : "No clopidogrel"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx02",
        "display" : "No voriconazole"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx03",
        "display" : "50% citalopram"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx04",
        "display" : "50% escitalopram"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/recommended-action",
      "valueReference" : {
        "reference" : "Task/PGxRecEx04",
        "display" : "50% amitriptyline"
      }
    },
    {
      "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report-note",
      "valueAnnotation" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/annotation-code",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/coded-annotation-types-cs",
                  "code" : "test-disclaimer"
                }
              ]
            }
          }
        ],
        "text" : "This test was developed and its performance determined by this laboratory. It has not been cleared or approved by U.S. Food and Drug Administration.\nSince FDA Approval is not required for clinical use of this test, this laboratory has established and validated the test's accuracy and precision,\npursuant to the requirement of CLIA '88. This laboratory is licensed and/or accredited under CLIA and CAP (CAP# xxxxxxx / CLIA# xxxxxxxxxx)."
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/eMERGEServiceRequest"
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "GE"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51969-4"
      },
      {
        "system" : "http://example.org/hgsc.bcm.edu/lab-test-codes/",
        "code" : "emerge-seq-ngs-pnl"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/CGPatientExample01"
  },
  "effectiveDateTime" : "2020-01-01T00:00:00-05:00",
  "issued" : "2020-01-01T00:00:00-05:00",
  "performer" : [
    {
      "reference" : "Organization/ExampleOrg"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/TxImp01",
      "display" : "clopidogrel, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp02",
      "display" : "voriconazole, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp03",
      "display" : "citalopram, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp04",
      "display" : "escitalopram, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp05",
      "display" : "amitriptyline, poor metabolizer"
    },
    {
      "reference" : "Observation/TxImp06",
      "display" : "medium sensitivity to warfarin"
    },
    {
      "reference" : "Observation/Pgx-geno-1001",
      "display" : "CYP2C19*2/*2"
    },
    {
      "reference" : "Observation/Pgx-geno-1003",
      "display" : "VKORC1 rs9923231 C/T"
    },
    {
      "reference" : "Observation/Pgx-geno-1002",
      "display" : "CYP2C9*1/*1"
    },
    {
      "reference" : "Observation/Pgx-var-1011",
      "display" : "NC_000010.10(CYP2C19):g.96521657C="
    },
    {
      "reference" : "Observation/Pgx-var-1012",
      "display" : "NC_000010.10(CYP2C19):g.96522463A="
    },
    {
      "reference" : "Observation/Pgx-var-1013",
      "display" : "NC_000010.10(CYP2C19):g.96535173T="
    },
    {
      "reference" : "Observation/Pgx-var-1014",
      "display" : "NC_000010.10(CYP2C19):g.96535210G="
    },
    {
      "reference" : "Observation/Pgx-var-1015",
      "display" : "NC_000010.10(CYP2C19):g.96540410G>A"
    },
    {
      "reference" : "Observation/Pgx-var-1016",
      "display" : "NC_000010.10(CYP2C19):g.96541616G="
    },
    {
      "reference" : "Observation/Pgx-var-1017",
      "display" : "NC_000010.10(CYP2C19):g.96541756T="
    },
    {
      "reference" : "Observation/Pgx-var-1018",
      "display" : "NC_000010.10(CYP2C19):g.96612495C="
    },
    {
      "reference" : "Observation/Pgx-var-1019",
      "display" : "NC_000016.9(VKORC1):g.31096368C>T"
    },
    {
      "reference" : "Observation/Pgx-var-1020",
      "display" : "NC_000010.10(CYP2C9):g.96702047C="
    },
    {
      "reference" : "Observation/Pgx-var-1021",
      "display" : "NC_000010.10(CYP2C9):g.96741053A="
    }
  ],
  "study" : [
    {
      "reference" : "GenomicStudy/PGXGenomicStudy"
    }
  ],
  "conclusion" : "Based on the genotype result, this patient is predicted to have a CYP2C19 poor metabolizer phenotype. This genotype information can be used by patients and clinicians as part of the shared decision-making process for several drugs metabolized by CYP2C19 including clopidogrel, voriconazole, amitriptyline, citalopram and escitalopram.",
  "conclusionCode" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA6576-8",
            "display" : "Positive"
          }
        ]
      }
    }
  ]
}

```
