# DNA Change Type Map - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **DNA Change Type Map**

## ConceptMap: DNA Change Type Map 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ConceptMap/dna-change-type-map | *Version*:4.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DNAChangeType |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org)… | | |

 
LOINC and SequenceOntology mappings for DNA change type 

Mapping from LOINC Answer Codes for LL379-9 to [DNA Change Type](ValueSet-dna-change-type-vs.md)

**Group 1**Mapping from [Logical Observation Identifiers, Names and Codes (LOINC)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html) to [Sequence Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-SO.html)

* **Source Code**: LA9658-1 (Wild type)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:0002073 (no_sequence_alteration)
* **Source Code**: LA6692-3 (Deletion)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:0000159 (deletion)
* **Source Code**: LA6686-5 (Duplication)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:1000035 (duplication)
* **Source Code**: LA6687-3 (Insertion)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:0000667 (insertion)
* **Source Code**: LA6688-1 (Insertion/Deletion)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:1000032 (delins)
* **Source Code**: LA6689-9 (Inversion)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:1000036 (inversion)
* **Source Code**: LA6690-7 (Substitution)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: SO:1000002 (substitution)



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "dna-change-type-map",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/ConceptMap/dna-change-type-map",
  "version" : "4.0.0-ballot",
  "name" : "DNAChangeType",
  "title" : "DNA Change Type Map",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "LOINC and SequenceOntology mappings for DNA change type",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org)...",
  "sourceScopeCanonical" : "http://loinc.org/vs/LL379-9",
  "targetScopeCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ValueSet/dna-change-type-vs",
  "group" : [
    {
      "source" : "http://loinc.org",
      "target" : "http://www.sequenceontology.org",
      "element" : [
        {
          "code" : "LA9658-1",
          "display" : "Wild type",
          "target" : [
            {
              "code" : "SO:0002073",
              "display" : "no_sequence_alteration",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6692-3",
          "display" : "Deletion",
          "target" : [
            {
              "code" : "SO:0000159",
              "display" : "deletion",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6686-5",
          "display" : "Duplication",
          "target" : [
            {
              "code" : "SO:1000035",
              "display" : "duplication",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6687-3",
          "display" : "Insertion",
          "target" : [
            {
              "code" : "SO:0000667",
              "display" : "insertion",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6688-1",
          "display" : "Insertion/Deletion",
          "target" : [
            {
              "code" : "SO:1000032",
              "display" : "delins",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6689-9",
          "display" : "Inversion",
          "target" : [
            {
              "code" : "SO:1000036",
              "display" : "inversion",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "LA6690-7",
          "display" : "Substitution",
          "target" : [
            {
              "code" : "SO:1000002",
              "display" : "substitution",
              "relationship" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
