# Variant Confidence Status Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Variant Confidence Status Codes**

## CodeSystem: Variant Confidence Status Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/variant-confidence-status-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:VariantConfidenceStatusCS |

 
A code that represents the confidence of a true positive variant call. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VariantConfidenceStatusVS](ValueSet-variant-confidence-status-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "variant-confidence-status-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/variant-confidence-status-cs",
  "version" : "4.0.0-ballot",
  "name" : "VariantConfidenceStatusCS",
  "title" : "Variant Confidence Status Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "A code that represents the confidence of a true positive variant call.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "high",
      "display" : "High",
      "definition" : "High confidence true positive variant call. Suitable for clinical reporting."
    },
    {
      "code" : "intermediate",
      "display" : "Intermediate",
      "definition" : "Candidate true positive variant call. Unable to confirm without additional testing."
    },
    {
      "code" : "low",
      "display" : "Low",
      "definition" : "High confidence false positive variant call."
    }
  ]
}

```
