# To Be Determined Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **To Be Determined Codes**

## CodeSystem: To Be Determined Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:TbdCodesCS |

 
These codes are 'TBD' codes, meaning they are important concepts but codes have not been identifed in available code systems. The CG WG anticpates these codes maturing over time. We may remove some codes as we refine the concepts, or identify suitable replacement codes from other code systems. As we approach normative and these concepts are validated, for codes that remain, we plan to request formal LOINC codes to replace these temporary codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TBDCodesVS](ValueSet-tbd-codes-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "tbd-codes-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
  "version" : "4.0.0-ballot",
  "name" : "TbdCodesCS",
  "title" : "To Be Determined Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "These codes are 'TBD' codes, meaning they are important concepts but codes have not been identifed in available code systems. The CG WG anticpates these codes maturing over time. We may remove some codes as we refine the concepts, or identify suitable replacement codes from other code systems. As we approach normative and these concepts are validated, for codes that remain, we plan to request formal LOINC codes to replace these temporary codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 17,
  "concept" : [
    {
      "code" : "associated-therapy",
      "display" : "Associated Therapy",
      "definition" : "The non-medication therapy (procedure) associated with this implication."
    },
    {
      "code" : "molecular-consequence",
      "display" : "Molecular Consequence",
      "definition" : "The calculated or observed effect of a DNA variant on its downstream transcript and, if applicable, ensuing protein sequence."
    },
    {
      "code" : "feature-consequence",
      "display" : "Feature Consequence",
      "definition" : "The structural implications of a variant (e.g. the variant disrupts a regulatory region, the variant is an inframe insertion)."
    },
    {
      "code" : "diagnostic-implication",
      "display" : "Diagnostic Implication",
      "definition" : "An observation linking a genomic finding with a knowledge base, providing context that may aid in diagnosing a patient with a particular phenotype or condition."
    },
    {
      "code" : "therapeutic-implication",
      "display" : "Therapeutic Implication",
      "definition" : "An observation linking a genomic finding with a knowledge base, providing potential evidence of an interaction with a specified medication or non-medicinal therapy. Ramifications may include alterations in drug metabolism (or pharmacokinetics) that determine the concentration of the drug, prodrug, and/or break-down products over time; alterations in drug efficacy (or pharmacodynamics) that determine how effective a drug is at a given concentration; alterations that alter the risk of adverse drug events, or other types of implications that indicate altered responsiveness to other types of therapies."
    },
    {
      "code" : "genomic-annotation",
      "display" : "Genomic Annotation",
      "definition" : "Profile for communicating the genome annotation derived from a genomic finding. Annotations are obtained from different databases (Clinvar,gnomad3,thousandgenomes etc.). NOTE: The bound Annotation Module value set is extensible. New annotation programs are being developed and old programs are being upodated/revised, meaning some annotation modules are outside the value set."
    },
    {
      "code" : "functional-effect",
      "display" : "Functional Effect",
      "definition" : "The effect of a variant on downstream biological products or pathways (from Sequence Ontology)."
    },
    {
      "code" : "conclusion-string",
      "display" : "Conclusion Text",
      "definition" : "Clinical conclusion (interpretation) of the observation."
    },
    {
      "code" : "condition-inheritance",
      "display" : "Condition Inheritance",
      "definition" : "The transmission pattern of the condition/phenotype in a pedigree."
    },
    {
      "code" : "variant-confidence-status",
      "display" : "Variant Confidence Status",
      "definition" : "The confidence of a true positive variant call."
    },
    {
      "code" : "repeat-motif",
      "display" : "Repeat Expansion Motif",
      "definition" : "Nucleotides of a repeat expansion motif."
    },
    {
      "code" : "repeat-number",
      "display" : "Number of Repeat Expansions",
      "definition" : "Number of repeats of a repeat expansion."
    },
    {
      "code" : "biomarker-category",
      "display" : "Biomarker Category",
      "definition" : "A characterization of a given biomarker observation."
    },
    {
      "code" : "protein-ref-seq",
      "display" : "Protein Reference Sequence",
      "definition" : "An identifier for the protein reference sequence."
    },
    {
      "code" : "conservation-score",
      "display" : "Conservation Score",
      "definition" : "The conservation score calculated for a genomic position or region indicating evolutionary conservation."
    },
    {
      "code" : "annotation-pipeline",
      "display" : "Annotation Pipeline",
      "definition" : "The name of the data pipeline that processed the genomic data file"
    },
    {
      "code" : "knowledge-base",
      "display" : "Knowledge Base",
      "definition" : "The database from which the annotation is derived"
    }
  ]
}

```
