# Knowledge Base Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Knowledge Base Codes**

## CodeSystem: Knowledge Base Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/knowledge-base-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:KnowledgeBaseCS |

 
This example code systems provides examples on how to properly display the knowledge base version number. Version numbers should always be followed by the letter v and calendar dates are displayed Month Day Year. For clarity the month SHALL be written in full. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [KnowledgeBaseVersionVS](ValueSet-knowledge-base-version-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "knowledge-base-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/knowledge-base-cs",
  "version" : "4.0.0-ballot",
  "name" : "KnowledgeBaseCS",
  "title" : "Knowledge Base Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This example code systems provides examples on how to properly display the knowledge base version number. Version numbers should always be followed by the letter v and calendar dates are displayed Month Day Year. For clarity the month SHALL be written in full.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 10,
  "concept" : [
    {
      "code" : "gnomadv4.1exome",
      "display" : "gnomad v4.1 exome",
      "definition" : "gnomAD version 4.1 exome"
    },
    {
      "code" : "gnomadv4.1genome",
      "display" : "gnomad v4.1 genome",
      "definition" : "gnomAD version 4.1 genome"
    },
    {
      "code" : "clinvar-april2024",
      "display" : "clinvar april 2024",
      "definition" : "Clinvar April 2024 release"
    },
    {
      "code" : "clinvar-march2024",
      "display" : "clinvar march 2024",
      "definition" : "Clinvar March 2024 release"
    },
    {
      "code" : "1000genomesv4.1.0",
      "display" : "1000genomes v4.1.0",
      "definition" : "1000genomes version 4.1.0"
    },
    {
      "code" : "civicv1.2.0",
      "display" : "civic v1.2.0",
      "definition" : "CIViC version 1.2.0"
    },
    {
      "code" : "graspv2.1.0",
      "display" : "grasp v2.1.0",
      "definition" : "GRASP version 2.1.0"
    },
    {
      "code" : "oncokbv1.5.2",
      "display" : "oncokb v1.5.2",
      "definition" : "OncoKB version 1.5.2"
    },
    {
      "code" : "pharmgkbv2.3.5",
      "display" : "pharmgkb v2.3.5",
      "definition" : "PharmGKB version 2.3.5"
    },
    {
      "code" : "phastconsv3.6.0",
      "display" : "phascons v.3.6.0",
      "definition" : "PhastCons version 3.6.0"
    }
  ]
}

```
