# Coded Annotation Type Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **Coded Annotation Type Codes**

## CodeSystem: Coded Annotation Type Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/coded-annotation-types-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:CodedAnnotationTypesCS |

 
Code System for specific types of coded annotations 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CodedAnnotationTypesVS](ValueSet-coded-annotation-types-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coded-annotation-types-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/coded-annotation-types-cs",
  "version" : "4.0.0-ballot",
  "name" : "CodedAnnotationTypesCS",
  "title" : "Coded Annotation Type Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Code System for specific types of coded annotations",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "test-disclaimer",
      "display" : "Test Disclaimer",
      "definition" : "Test disclaimer with the report"
    },
    {
      "code" : "test-methodology",
      "display" : "Test Methodology",
      "definition" : "Additional details regarding the test methdology"
    },
    {
      "code" : "result-confirmation",
      "display" : "Result Confirmation",
      "definition" : "Additional details regarding the confirmation of the results"
    }
  ]
}

```
