# ClinVar Evidence Level Example Codes - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **ClinVar Evidence Level Example Codes**

## CodeSystem: ClinVar Evidence Level Example Codes (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/clinvar-evidence-level-custom-cs | *Version*:4.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) | *Computable Name*:ClinVarEvidenceLevelCustomCS |

 
ClinVar contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on ClinVar https://www.ncbi.nlm.nih.gov/clinvar/docs/review_status/ . These examples are informational only, for copyright information contact the relevant source. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EvidenceLevelExampleVS](ValueSet-evidence-level-example-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "clinvar-evidence-level-custom-cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/genomics-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/clinvar-evidence-level-custom-cs",
  "version" : "4.0.0-ballot",
  "name" : "ClinVarEvidenceLevelCustomCS",
  "title" : "ClinVar Evidence Level Example Codes",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T23:38:27+00:00",
  "publisher" : "HL7 International / Clinical Genomics",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Genomics",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/clingenomics"
        },
        {
          "system" : "email",
          "value" : "cg@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "ClinVar contains examples of evidence level concepts that are not conflated with clinical significance. These can be found on  ClinVar https://www.ncbi.nlm.nih.gov/clinvar/docs/review_status/ . These examples are informational only, for copyright information contact the relevant source.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5,
  "concept" : [
    {
      "code" : "4-star",
      "display" : "4 star",
      "definition" : "Supported by practice guideline"
    },
    {
      "code" : "3-star",
      "display" : "3 star",
      "definition" : "Supported by expert panel review"
    },
    {
      "code" : "2-star",
      "display" : "2 star",
      "definition" : "Supported by submission by multiple-submitters with documentation of criteria for assertion"
    },
    {
      "code" : "1-star",
      "display" : "1 star",
      "definition" : "Single submitter providing interpretation and documentation of criteria for assertion"
    },
    {
      "code" : "no-star",
      "display" : "no star",
      "definition" : "submitted, no evidence"
    }
  ]
}

```
