# bundle-sequence-phase-relation-CYP2C19 - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-sequence-phase-relation-CYP2C19**

## Example Bundle: bundle-sequence-phase-relation-CYP2C19

Bundle bundle-sequence-phase-relation-CYP2C19 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfe60

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:Present
> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:Genomic reference sequence ID**value**:NC_000010.10

> **component****code**:Allelic state**value**:heterozygous

> **component****code**:Ref nucleotide**value**: C

> **component****code**:Alt allele**value**: A

> **component****code**:Genomic coord system**value**:1-based character counting

> **component****code**:Genomic allele start-end**value**: 96527334-?

Request:

```
POST Observation

```

-------

Entry 2 - fullUrl = urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe01

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:Present
> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:Genomic reference sequence ID**value**:NC_000010.10

> **component****code**:Allelic state**value**:heterozygous

> **component****code**:Ref nucleotide**value**: C

> **component****code**:Alt allele**value**: G

> **component****code**:Genomic coord system**value**:1-based character counting

> **component****code**:Genomic allele start-end**value**: 96527722-?

Request:

```
POST Observation

```

-------

Entry 3 - fullUrl = urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe02

Resource Observation:

> 

Profile: [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)

**status**: Final**category**:Laboratory,Genetics**code**:Allelic phase**subject**:[John Storm(official) Male, DoB: 1986-12-31](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac)**effective**: 2019-03-05**issued**: 2019-03-05 16:04:44+0000**performer**:[Organization aTypingLab Inc](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab)**value**:Cis**derivedFrom**:
* [Observation Genetic variant assessment](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfe60)
* [Observation Genetic variant assessment](Bundle-bundle-CYP2C19.md#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe01)

Request:

```
POST Observation

```

-------

Entry 4 - fullUrl = urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe03

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

|
|

**Report Details**

* **Code**: [Genetic variant assessment](Bundle-bundle-CYP2C19.md#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfe60)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 2019-03-05 16:04:44+0000
* **Code**: [Genetic variant assessment](Bundle-bundle-CYP2C19.md#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe01)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 2019-03-05 16:04:44+0000
* **Code**: [Allelic phase](Bundle-bundle-sequence-phase-relation-CYP2C19.md#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe02)
  * **Value**: Cis
  * **Flags**: Final
  * **When For**: 2019-03-05
  * **Reported**: 2019-03-05 16:04:44+0000


Request:

```
POST DiagnosticReport

```

-------

Entry 5 - fullUrl = urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab

Resource Organization:

> **name**: aTypingLab Inc**alias**: aTL

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 1-800-555-1234(Work) | 123 Main St, Sometown, ND 99999(work) |


Request:

```
POST Organization

```

-------

Entry 6 - fullUrl = urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac

Resource Patient:

> John Storm(official) Male, DoB: 1986-12-31
-------

Request:

```
POST Patient

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-sequence-phase-relation-CYP2C19",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfe60",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "dv-5c7e9e1ca8252",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_dv-5c7e9e1ca8252\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation dv-5c7e9e1ca8252</b></p><a name=\"dv-5c7e9e1ca8252\"> </a><a name=\"hcdv-5c7e9e1ca8252\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48013-7}\">Genomic reference sequence ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NC_000010.10}\">NC_000010.10</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53034-5}\">Allelic state</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6706-1}\">heterozygous</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Ref nucleotide</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69551-0}\">Alt allele</span></p><p><b>value</b>: A</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 92822-6}\">Genomic coord system</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30102-0}\">1-based character counting</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81254-5}\">Genomic allele start-end</span></p><p><b>value</b>: 96527334-?</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NC_000010.10"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5",
                  "display" : "Allelic state"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "heterozygous"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Ref nucleotide"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Alt allele"
                }
              ]
            },
            "valueString" : "A"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "92822-6",
                  "display" : "Genomic coord system"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30102-0"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 96527334
              }
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe01",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "dv-5c7e9e1ca82e4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_dv-5c7e9e1ca82e4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation dv-5c7e9e1ca82e4</b></p><a name=\"dv-5c7e9e1ca82e4\"> </a><a name=\"hcdv-5c7e9e1ca82e4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48013-7}\">Genomic reference sequence ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NC_000010.10}\">NC_000010.10</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53034-5}\">Allelic state</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6706-1}\">heterozygous</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Ref nucleotide</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69551-0}\">Alt allele</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 92822-6}\">Genomic coord system</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30102-0}\">1-based character counting</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81254-5}\">Genomic allele start-end</span></p><p><b>value</b>: 96527722-?</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48013-7",
                  "display" : "Genomic reference sequence ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NC_000010.10"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53034-5",
                  "display" : "Allelic state"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6706-1",
                  "display" : "heterozygous"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Ref nucleotide"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69551-0",
                  "display" : "Alt allele"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "92822-6",
                  "display" : "Genomic coord system"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30102-0"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81254-5"
                }
              ]
            },
            "valueRange" : {
              "low" : {
                "value" : 96527722
              }
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe02",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "sid-5c7e9e1ca8a29",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/sequence-phase-relationship"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_sid-5c7e9e1ca8a29\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation sid-5c7e9e1ca8a29</b></p><a name=\"sid-5c7e9e1ca8a29\"> </a><a name=\"hcsid-5c7e9e1ca8a29\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-sequence-phase-relationship.html\">Sequence Phase Relationship</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82120-7}\">Allelic phase</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeac\">John Storm(official) Male, DoB: 1986-12-31</a></p><p><b>effective</b>: 2019-03-05</p><p><b>issued</b>: 2019-03-05 16:04:44+0000</p><p><b>performer</b>: <a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfeab\">Organization aTypingLab Inc</a></p><p><b>value</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs Cis}\">Cis</span></p><p><b>derivedFrom</b>: </p><ul><li><a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfe60\">Observation Genetic variant assessment</a></li><li><a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe01\">Observation Genetic variant assessment</a></li></ul></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82120-7",
              "display" : "Allelic phase"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac"
        },
        "effectiveDateTime" : "2019-03-05",
        "issued" : "2019-03-05T16:04:44+00:00",
        "performer" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs",
              "code" : "Cis",
              "display" : "Cis"
            }
          ]
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfe60"
          },
          {
            "reference" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe01"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe03",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "sequence-phase-relation-CYP2C19",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_sequence-phase-relation-CYP2C19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport sequence-phase-relation-CYP2C19</b></p><a name=\"sequence-phase-relation-CYP2C19\"> </a><a name=\"hcsequence-phase-relation-CYP2C19\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"/><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td><td><b>Reported</b></td></tr><tr><td><a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-19ac0aeb-6bd4-4e92-a891-d44a807bfe60\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2019-03-05</td><td>2019-03-05 16:04:44+0000</td></tr><tr><td><a href=\"Bundle-bundle-CYP2C19.html#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe01\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2019-03-05</td><td>2019-03-05 16:04:44+0000</td></tr><tr><td><a href=\"Bundle-bundle-sequence-phase-relation-CYP2C19.html#urn-uuid-20ac0aeb-6bd4-4e92-a891-d44a807bfe02\"><span title=\"Codes:{http://loinc.org 82120-7}\">Allelic phase</span></a></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/sequence-phase-relationship-cs Cis}\">Cis</span></td><td>Final</td><td>2019-03-05</td><td>2019-03-05 16:04:44+0000</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4"
            }
          ]
        },
        "result" : [
          {
            "reference" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfe60"
          },
          {
            "reference" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe01"
          },
          {
            "reference" : "urn:uuid:20ac0aeb-6bd4-4e92-a891-d44a807bfe02"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    },
    {
      "fullUrl" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeab",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "performingLab",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_performingLab\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization performingLab</b></p><a name=\"performingLab\"> </a><a name=\"hcperformingLab\"> </a><p><b>name</b>: aTypingLab Inc</p><p><b>alias</b>: aTL</p><h3>Contacts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Telecom</b></td><td><b>Address</b></td></tr><tr><td style=\"display: none\">*</td><td>ph: 1-800-555-1234(Work)</td><td>123 Main St, Sometown, ND 99999(work)</td></tr></table></div>"
        },
        "name" : "aTypingLab Inc",
        "alias" : ["aTL"],
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "1-800-555-1234",
                "use" : "work",
                "rank" : 1
              }
            ],
            "address" : {
              "use" : "work",
              "type" : "physical",
              "text" : "123 Main St, Sometown, ND 99999",
              "line" : ["123 Main St"],
              "city" : "Sometown",
              "state" : "ND",
              "postalCode" : "99999",
              "country" : "USA"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:19ac0aeb-6bd4-4e92-a891-d44a807bfeac",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient patient</b></p><a name=\"patient\"> </a><a name=\"hcpatient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">John Storm(official) Male, DoB: 1986-12-31</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 1-800-555-1234(Work)</li><li>123 Main St, Sometown, ND 99999(work)</li></ul></td></tr></table></div>"
        },
        "name" : [
          {
            "use" : "official",
            "text" : "John Storm",
            "family" : "Storm",
            "given" : ["John"]
          },
          {
            "use" : "nickname",
            "text" : "Johnny Storm",
            "family" : "Storm",
            "given" : ["Johnny"]
          },
          {
            "use" : "nickname",
            "text" : "The Human Torch"
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "1-800-555-1234",
            "use" : "work",
            "rank" : 1
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-12-31",
        "address" : [
          {
            "use" : "work",
            "type" : "physical",
            "text" : "123 Main St, Sometown, ND 99999",
            "line" : ["123 Main St"],
            "city" : "Sometown",
            "state" : "ND",
            "postalCode" : "99999",
            "country" : "USA"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    }
  ]
}

```
