# bundle-oncology-report-example - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-oncology-report-example**

## Example Bundle: bundle-oncology-report-example

Bundle bundle-oncology-report-example of type transaction

-------

Entry 1 - fullUrl = urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17

Resource Organization:

> **identifier**:`http://example.org/genomics/NamingSystem/organization`/CEGAT**name**: CEGAT

Request:

```
POST Organization
If-None-Exist = identifier=http://example.org/genomics/NamingSystem/organization|CEGAT

```

-------

Entry 2 - fullUrl = urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648

Resource Patient:

> Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)
-------

Request:

```
POST Patient
If-None-Exist = identifier=http://example.org/genomics/NamingSystem/cegat/patID|11111

```

-------

Entry 3 - fullUrl = urn:uuid:a2041c83-b73d-4fc8-9466-4ba4a92da516

Resource Specimen:

> **identifier**:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN**type**:Tumor**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)
> **collection****method**:Biopsy

### BodySites

| | |
| :--- | :--- |
| - | **Concept** |
| * | Malignant neoplasm of cardia |



Request:

```
POST Specimen
If-None-Exist = identifier=http://example.org/genomics/NamingSystem/cegat/tissueID|UNKNOWN

```

-------

Entry 4 - fullUrl = urn:uuid:dac358c3-403a-4dbb-b478-4259aed882ae

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:PIK3CA

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_006218.4:c.3140A>G

> **component****code**:DNA change type**value**:substitution

> **component****code**:Amino acid change (pHGVS)**value**:NP_006209.2:p.His1047Arg

> **component****code**:Transcript reference sequence [ID]**value**:NM_006218.4

> **component****code**:Genomic ref allele [ID]**value**: A

> **component****code**:Sample VAF**value**: 0.2188 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 64 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 5 - fullUrl = urn:uuid:1d773d66-cec7-44a2-b92a-46d00adeae00

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:NRAS

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_002524.4:c.34G>T

> **component****code**:DNA change type**value**:substitution

> **component****code**:Transcript reference sequence [ID]**value**:NM_002524.4

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Sample VAF**value**: 0.1793 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 145 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 6 - fullUrl = urn:uuid:842d9ab9-d940-4f0c-adf9-e5c528f5c0e5

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:FBXW7

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_001349798.2:c.1394G>A

> **component****code**:DNA change type**value**:substitution

> **component****code**:Amino acid change (pHGVS)**value**:NP_001336727.1:p.Arg465His

> **component****code**:Transcript reference sequence [ID]**value**:NM_001349798.2

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Sample VAF**value**: 0.1053 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 57 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 7 - fullUrl = urn:uuid:9a9f9a4a-52e3-4738-bd0b-a25374bbf358

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:KMT2D

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_003482.3:c.7900_7901delCA

> **component****code**:DNA change type**value**:deletion

> **component****code**:Transcript reference sequence [ID]**value**:NM_003482.3

> **component****code**:Genomic ref allele [ID]**value**: CTG

> **component****code**:Sample VAF**value**: 0.188 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 117 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 8 - fullUrl = urn:uuid:58828523-8893-45fc-973b-16290366c5e5

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:PIK3CA

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_006218.3:c.333G>T

> **component****code**:DNA change type**value**:substitution

> **component****code**:Transcript reference sequence [ID]**value**:NM_006218.3

> **component****code**:Genomic ref allele [ID]**value**: G

> **component****code**:Sample VAF**value**: 0.1471 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 68 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 9 - fullUrl = urn:uuid:2c28b23f-3e9f-4c03-8c8f-0e76bc5dc9c2

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:IRS2

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_003749.2:c.3960C>T

> **component****code**:DNA change type**value**:substitution

> **component****code**:Transcript reference sequence [ID]**value**:NM_003749.2

> **component****code**:Genomic ref allele [ID]**value**: G

> **component****code**:Sample VAF**value**: 0.1343 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 134 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = urn:uuid:41bebbe5-e06f-4867-aa22-7c06db69dbd1

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:CDKN2A

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_000077.4:c.9_32del

> **component****code**:DNA change type**value**:deletion

> **component****code**:Amino acid change (pHGVS)**value**:NP_000068.1:p.Ala4_Pro11del

> **component****code**:Transcript reference sequence [ID]**value**:NM_000077.4

> **component****code**:Genomic ref allele [ID]**value**: AGGCTCCATGCTGCTCCCCGCCGCC

> **component****code**:Sample VAF**value**: 0.0536 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 112 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 11 - fullUrl = urn:uuid:1642f190-e2c6-4999-8040-b9b2a70618bf

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:RECQL4

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_004260.4:c.2086C>T

> **component****code**:DNA change type**value**:substitution

> **component****code**:Amino acid change (pHGVS)**value**:NP_004251.4:p.Arg696Cys

> **component****code**:Transcript reference sequence [ID]**value**:NM_004260.4

> **component****code**:Genomic ref allele [ID]**value**: G

> **component****code**:Sample VAF**value**: 0.2568 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 148 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = urn:uuid:c3587931-242f-4129-93f9-be24500c8f29

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:RYR1

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_000540.3:c.4964G>A

> **component****code**:DNA change type**value**:substitution

> **component****code**:Amino acid change (pHGVS)**value**:NP_000531.2:p.Arg1655Leu

> **component****code**:Transcript reference sequence [ID]**value**:NM_000540.3

> **component****code**:Genomic ref allele [ID]**value**: G

> **component****code**:Sample VAF**value**: 0.2151 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 93 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = urn:uuid:41695fc0-1fd5-4cc8-95e6-82b2848a5cb6

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:SACS

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_014363.5:c.12118G>A

> **component****code**:DNA change type**value**:substitution

> **component****code**:Transcript reference sequence [ID]**value**:NM_014363.5

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Sample VAF**value**: 0.3333 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 60 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 14 - fullUrl = urn:uuid:58eb14f6-4059-4168-86a9-155ae61d30e2

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:SLIT2

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_004787.3:c.1290C>A

> **component****code**:DNA change type**value**:substitution

> **component****code**:Transcript reference sequence [ID]**value**:NM_004787.3

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Sample VAF**value**: 0.2642 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 53 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = urn:uuid:1a71e80f-b044-4a91-80e1-eadbe5a53dca

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)](Bundle-bundle-oncology-report-example.md#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648)**effective**: 2023-03-05**performer**:[Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17)**value**:Present**method**:Sequencing**specimen**: Identifier:`http://example.org/genomics/NamingSystem/cegat/tissueID`/UNKNOWN
> **component****code**:Genomic source class**value**:Somatic

> **component****code**:Gene studied [ID]**value**:SMARCA4

> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:DNA change (c.HGVS)**value**:NM_003072.5:c.2372C>T

> **component****code**:DNA change type**value**:substitution

> **component****code**:Amino acid change (pHGVS)**value**:NP_003063.2:p.Ala791Val

> **component****code**:Transcript reference sequence [ID]**value**:NM_003072.5

> **component****code**:Genomic ref allele [ID]**value**: C

> **component****code**:Sample VAF**value**: 0.1938 relative frequency of a particular allele in the specimen(Details: UCUM code1 = '1')

> **component****code**:Allelic read depth**value**: 160 reads per base pair(Details: UCUM code1 = '1')

Request:

```
POST Observation

```

-------

Entry 16 - fullUrl = urn:uuid:6a80003f-822d-489e-8286-1f1dcba56dfa

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111) |
| Reported | 2019-09-15 11:35:05-0400 |
| Performer | [Organization CEGAT](Bundle-bundle-oncology-report-example.md#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17) |
| Identifier | `http://example.org/genomics/NamingSystem/cegat/reportID`/42867 |

**Report Details**

* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-dac358c3-403a-4dbb-b478-4259aed882ae)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-1d773d66-cec7-44a2-b92a-46d00adeae00)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-842d9ab9-d940-4f0c-adf9-e5c528f5c0e5)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-9a9f9a4a-52e3-4738-bd0b-a25374bbf358)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-58828523-8893-45fc-973b-16290366c5e5)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-2c28b23f-3e9f-4c03-8c8f-0e76bc5dc9c2)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-41bebbe5-e06f-4867-aa22-7c06db69dbd1)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-1642f190-e2c6-4999-8040-b9b2a70618bf)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-c3587931-242f-4129-93f9-be24500c8f29)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-41695fc0-1fd5-4cc8-95e6-82b2848a5cb6)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-58eb14f6-4059-4168-86a9-155ae61d30e2)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05
* **Code**: [Genetic variant assessment](Bundle-bundle-oncology-report-example.md#urn-uuid-1a71e80f-b044-4a91-80e1-eadbe5a53dca)
  * **Value**: Present
  * **Flags**: Final
  * **When For**: 2023-03-05


Request:

```
POST DiagnosticReport

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-oncology-report-example",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "Inline-Instance-for-oncology-report-example-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_Inline-Instance-for-oncology-report-example-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization Inline-Instance-for-oncology-report-example-1</b></p><a name=\"Inline-Instance-for-oncology-report-example-1\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-1\"> </a><p><b>identifier</b>: <code>http://example.org/genomics/NamingSystem/organization</code>/CEGAT</p><p><b>name</b>: CEGAT</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/genomics/NamingSystem/organization",
            "value" : "CEGAT"
          }
        ],
        "name" : "CEGAT"
      },
      "request" : {
        "method" : "POST",
        "url" : "Organization",
        "ifNoneExist" : "identifier=http://example.org/genomics/NamingSystem/organization|CEGAT"
      }
    },
    {
      "fullUrl" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Inline-Instance-for-oncology-report-example-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Inline-Instance-for-oncology-report-example-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Inline-Instance-for-oncology-report-example-2</b></p><a name=\"Inline-Instance-for-oncology-report-example-2\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-2\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</p><hr/></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/genomics/NamingSystem/cegat/patID",
            "value" : "11111"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient",
        "ifNoneExist" : "identifier=http://example.org/genomics/NamingSystem/cegat/patID|11111"
      }
    },
    {
      "fullUrl" : "urn:uuid:a2041c83-b73d-4fc8-9466-4ba4a92da516",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "Inline-Instance-for-oncology-report-example-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_Inline-Instance-for-oncology-report-example-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen Inline-Instance-for-oncology-report-example-3</b></p><a name=\"Inline-Instance-for-oncology-report-example-3\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-3\"> </a><p><b>identifier</b>: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0487 TUMOR}\">Tumor</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><blockquote><p><b>collection</b></p><p><b>method</b>: <span title=\"Codes:\">Biopsy</span></p><h3>BodySites</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Concept</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm C16.0}\">Malignant neoplasm of cardia</span></td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        ],
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
              "code" : "TUMOR",
              "display" : "Tumor"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "collection" : {
          "method" : {
            "text" : "Biopsy"
          },
          "bodySite" : {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/sid/icd-10-cm",
                  "code" : "C16.0"
                }
              ]
            }
          }
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Specimen",
        "ifNoneExist" : "identifier=http://example.org/genomics/NamingSystem/cegat/tissueID|UNKNOWN"
      }
    },
    {
      "fullUrl" : "urn:uuid:dac358c3-403a-4dbb-b478-4259aed882ae",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-4</b></p><a name=\"Inline-Instance-for-oncology-report-example-4\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:8975}\">PIK3CA</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_006218.4:c.3140A&gt;G}\">NM_006218.4:c.3140A&gt;G</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_006209.2:p.His1047Arg}\">NP_006209.2:p.His1047Arg</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_006218.3}\">NM_006218.4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: A</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.2188 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 64 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:8975",
                  "display" : "PIK3CA"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_006218.4:c.3140A>G",
                  "display" : "NM_006218.4:c.3140A>G"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_006209.2:p.His1047Arg",
                  "display" : "NP_006209.2:p.His1047Arg"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_006218.3",
                  "display" : "NM_006218.4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "A"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.2188,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 64,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1d773d66-cec7-44a2-b92a-46d00adeae00",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-5</b></p><a name=\"Inline-Instance-for-oncology-report-example-5\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:7989}\">NRAS</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_002524.4:c.34G&gt;T}\">NM_002524.4:c.34G&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_002524.4}\">NM_002524.4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.1793 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 145 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:7989",
                  "display" : "NRAS"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_002524.4:c.34G>T",
                  "display" : "NM_002524.4:c.34G>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_002524.4",
                  "display" : "NM_002524.4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.1793,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 145,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:842d9ab9-d940-4f0c-adf9-e5c528f5c0e5",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-6",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-6</b></p><a name=\"Inline-Instance-for-oncology-report-example-6\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:16712}\">FBXW7</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_001349798.2:c.1394G&gt;A}\">NM_001349798.2:c.1394G&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_001336727.1:p.Arg465His}\">NP_001336727.1:p.Arg465His</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_001349798.2}\">NM_001349798.2</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.1053 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 57 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:16712",
                  "display" : "FBXW7"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_001349798.2:c.1394G>A",
                  "display" : "NM_001349798.2:c.1394G>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_001336727.1:p.Arg465His",
                  "display" : "NP_001336727.1:p.Arg465His"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_001349798.2",
                  "display" : "NM_001349798.2"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.1053,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 57,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:9a9f9a4a-52e3-4738-bd0b-a25374bbf358",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-7",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-7</b></p><a name=\"Inline-Instance-for-oncology-report-example-7\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:7133}\">KMT2D</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_003482.3:c.7900_7901delCA}\">NM_003482.3:c.7900_7901delCA</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:0000159}\">deletion</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_003482.3}\">NM_003482.3</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: CTG</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.188 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 117 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:7133",
                  "display" : "KMT2D"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_003482.3:c.7900_7901delCA",
                  "display" : "NM_003482.3:c.7900_7901delCA"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0000159",
                  "display" : "deletion"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_003482.3",
                  "display" : "NM_003482.3"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "CTG"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.188,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 117,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:58828523-8893-45fc-973b-16290366c5e5",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-8",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-8</b></p><a name=\"Inline-Instance-for-oncology-report-example-8\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:8975}\">PIK3CA</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_006218.3:c.333G&gt;T}\">NM_006218.3:c.333G&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_006218.3}\">NM_006218.3</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.1471 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 68 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:8975",
                  "display" : "PIK3CA"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_006218.3:c.333G>T",
                  "display" : "NM_006218.3:c.333G>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_006218.3",
                  "display" : "NM_006218.3"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.1471,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 68,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:2c28b23f-3e9f-4c03-8c8f-0e76bc5dc9c2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-9",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-9</b></p><a name=\"Inline-Instance-for-oncology-report-example-9\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:6126}\">IRS2</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_003749.2:c.3960C&gt;T}\">NM_003749.2:c.3960C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_003749.2}\">NM_003749.2</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.1343 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 134 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:6126",
                  "display" : "IRS2"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_003749.2:c.3960C>T",
                  "display" : "NM_003749.2:c.3960C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_003749.2",
                  "display" : "NM_003749.2"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.1343,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 134,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:41bebbe5-e06f-4867-aa22-7c06db69dbd1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-10",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-10\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-10</b></p><a name=\"Inline-Instance-for-oncology-report-example-10\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-10\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:1787}\">CDKN2A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_000077.4:c.9_32del}\">NM_000077.4:c.9_32del</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:0000159}\">deletion</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_000068.1:p.Ala4_Pro11del}\">NP_000068.1:p.Ala4_Pro11del</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_000077.4}\">NM_000077.4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: AGGCTCCATGCTGCTCCCCGCCGCC</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.0536 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 112 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:1787",
                  "display" : "CDKN2A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_000077.4:c.9_32del"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:0000159",
                  "display" : "deletion"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_000068.1:p.Ala4_Pro11del"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_000077.4",
                  "display" : "NM_000077.4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "AGGCTCCATGCTGCTCCCCGCCGCC"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.0536,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 112,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1642f190-e2c6-4999-8040-b9b2a70618bf",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-11",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-11</b></p><a name=\"Inline-Instance-for-oncology-report-example-11\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-11\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:9949}\">RECQL4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_004260.4:c.2086C&gt;T}\">NM_004260.4:c.2086C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_004251.4:p.Arg696Cys}\">NP_004251.4:p.Arg696Cys</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_004260.4}\">NM_004260.4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.2568 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 148 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:9949",
                  "display" : "RECQL4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_004260.4:c.2086C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_004251.4:p.Arg696Cys"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_004260.4",
                  "display" : "NM_004260.4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.2568,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 148,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:c3587931-242f-4129-93f9-be24500c8f29",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-12",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-12\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-12</b></p><a name=\"Inline-Instance-for-oncology-report-example-12\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-12\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:10483}\">RYR1</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_000540.3:c.4964G&gt;A}\">NM_000540.3:c.4964G&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_000531.2:p.Arg1655Leu}\">NP_000531.2:p.Arg1655Leu</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_000540.2}\">NM_000540.3</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: G</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.2151 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 93 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:10483",
                  "display" : "RYR1"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_000540.3:c.4964G>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_000531.2:p.Arg1655Leu"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_000540.2",
                  "display" : "NM_000540.3"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "G"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.2151,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 93,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:41695fc0-1fd5-4cc8-95e6-82b2848a5cb6",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-13",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-13</b></p><a name=\"Inline-Instance-for-oncology-report-example-13\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-13\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:10519}\">SACS</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_014363.5:c.12118G&gt;A}\">NM_014363.5:c.12118G&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_014363.5}\">NM_014363.5</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.3333 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 60 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:10519",
                  "display" : "SACS"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_014363.5:c.12118G>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_014363.5",
                  "display" : "NM_014363.5"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.3333,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 60,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:58eb14f6-4059-4168-86a9-155ae61d30e2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-14",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-14</b></p><a name=\"Inline-Instance-for-oncology-report-example-14\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-14\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:11086}\">SLIT2</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_004787.3:c.1290C&gt;A}\">NM_004787.3:c.1290C&gt;A</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_004787.3}\">NM_004787.3</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.2642 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 53 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:11086",
                  "display" : "SLIT2"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_004787.3:c.1290C>A"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_004787.3",
                  "display" : "NM_004787.3"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.2642,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 53,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1a71e80f-b044-4a91-80e1-eadbe5a53dca",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-report-example-15",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-report-example-15\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-report-example-15</b></p><a name=\"Inline-Instance-for-oncology-report-example-15\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-15\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-f7a438e6-f484-453d-97e8-aa4d51008648\">Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</a></p><p><b>effective</b>: 2023-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: Identifier: <code>http://example.org/genomics/NamingSystem/cegat/tissueID</code>/UNKNOWN</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48002-0}\">Genomic source class</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6684-0}\">Somatic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:11100}\">SMARCA4</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48004-6}\">DNA change (c.HGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NM_003072.5:c.2372C&gt;T}\">NM_003072.5:c.2372C&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48019-4}\">DNA change type</span></p><p><b>value</b>: <span title=\"Codes:{http://www.sequenceontology.org SO:1000002}\">substitution</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_003063.2:p.Ala791Val}\">NP_003063.2:p.Ala791Val</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 51958-7}\">Transcript reference sequence [ID]</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/refseq NM_003072.5}\">NM_003072.5</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69547-8}\">Genomic ref allele [ID]</span></p><p><b>value</b>: C</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81258-6}\">Sample VAF</span></p><p><b>value</b>: 0.1938 relative frequency of a particular allele in the specimen<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82121-5}\">Allelic read depth</span></p><p><b>value</b>: 160 reads per base pair<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1 = '1')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "effectiveDateTime" : "2023-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "identifier" : {
            "system" : "http://example.org/genomics/NamingSystem/cegat/tissueID",
            "value" : "UNKNOWN"
          }
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48002-0",
                  "display" : "Genomic source class"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6684-0",
                  "display" : "Somatic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:11100",
                  "display" : "SMARCA4"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48004-6",
                  "display" : "DNA change (c.HGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NM_003072.5:c.2372C>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48019-4",
                  "display" : "DNA change type"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.sequenceontology.org",
                  "code" : "SO:1000002",
                  "display" : "substitution"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_003063.2:p.Ala791Val"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "51958-7",
                  "display" : "Transcript reference sequence [ID]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/refseq",
                  "code" : "NM_003072.5",
                  "display" : "NM_003072.5"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69547-8",
                  "display" : "Genomic ref allele [ID]"
                }
              ]
            },
            "valueString" : "C"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81258-6",
                  "display" : "Sample VAF"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 0.1938,
              "unit" : "relative frequency of a particular allele in the specimen",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "82121-5",
                  "display" : "Allelic read depth"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 160,
              "unit" : "reads per base pair",
              "system" : "http://unitsofmeasure.org",
              "code" : "1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:6a80003f-822d-489e-8286-1f1dcba56dfa",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "Inline-Instance-for-oncology-report-example-16",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_Inline-Instance-for-oncology-report-example-16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport Inline-Instance-for-oncology-report-example-16</b></p><a name=\"Inline-Instance-for-oncology-report-example-16\"> </a><a name=\"hcInline-Instance-for-oncology-report-example-16\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Anonymous Patient (no stated gender), DoB Unknown ( http://example.org/genomics/NamingSystem/cegat/patID#11111)</td></tr><tr><td>Reported</td><td>2019-09-15 11:35:05-0400</td></tr><tr><td>Performer</td><td> <a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-fc16d84c-8584-4e1d-baae-64e2f95bfe17\">Organization CEGAT</a></td></tr><tr><td>Identifier</td><td> <code>http://example.org/genomics/NamingSystem/cegat/reportID</code>/42867</td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-dac358c3-403a-4dbb-b478-4259aed882ae\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-1d773d66-cec7-44a2-b92a-46d00adeae00\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-842d9ab9-d940-4f0c-adf9-e5c528f5c0e5\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-9a9f9a4a-52e3-4738-bd0b-a25374bbf358\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-58828523-8893-45fc-973b-16290366c5e5\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-2c28b23f-3e9f-4c03-8c8f-0e76bc5dc9c2\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-41bebbe5-e06f-4867-aa22-7c06db69dbd1\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-1642f190-e2c6-4999-8040-b9b2a70618bf\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-c3587931-242f-4129-93f9-be24500c8f29\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-41695fc0-1fd5-4cc8-95e6-82b2848a5cb6\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-58eb14f6-4059-4168-86a9-155ae61d30e2\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr><tr><td><a href=\"Bundle-bundle-oncology-report-example.html#urn-uuid-1a71e80f-b044-4a91-80e1-eadbe5a53dca\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2023-03-05</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/genomics/NamingSystem/cegat/reportID",
            "value" : "42867"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4",
              "display" : "Genetic analysis report"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:f7a438e6-f484-453d-97e8-aa4d51008648"
        },
        "issued" : "2019-09-15T11:35:05.722-04:00",
        "performer" : [
          {
            "reference" : "urn:uuid:fc16d84c-8584-4e1d-baae-64e2f95bfe17"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:a2041c83-b73d-4fc8-9466-4ba4a92da516"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:dac358c3-403a-4dbb-b478-4259aed882ae"
          },
          {
            "reference" : "urn:uuid:1d773d66-cec7-44a2-b92a-46d00adeae00"
          },
          {
            "reference" : "urn:uuid:842d9ab9-d940-4f0c-adf9-e5c528f5c0e5"
          },
          {
            "reference" : "urn:uuid:9a9f9a4a-52e3-4738-bd0b-a25374bbf358"
          },
          {
            "reference" : "urn:uuid:58828523-8893-45fc-973b-16290366c5e5"
          },
          {
            "reference" : "urn:uuid:2c28b23f-3e9f-4c03-8c8f-0e76bc5dc9c2"
          },
          {
            "reference" : "urn:uuid:41bebbe5-e06f-4867-aa22-7c06db69dbd1"
          },
          {
            "reference" : "urn:uuid:1642f190-e2c6-4999-8040-b9b2a70618bf"
          },
          {
            "reference" : "urn:uuid:c3587931-242f-4129-93f9-be24500c8f29"
          },
          {
            "reference" : "urn:uuid:41695fc0-1fd5-4cc8-95e6-82b2848a5cb6"
          },
          {
            "reference" : "urn:uuid:58eb14f6-4059-4168-86a9-155ae61d30e2"
          },
          {
            "reference" : "urn:uuid:1a71e80f-b044-4a91-80e1-eadbe5a53dca"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    }
  ]
}

```
