# bundle-oncology-diagnostic - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifact List**](artifacts.md)
* **bundle-oncology-diagnostic**

## Example Bundle: bundle-oncology-diagnostic

Bundle bundle-oncology-diagnostic of type transaction

-------

Entry 1 - fullUrl = urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d

Resource Patient:

> Carrot John Mr Male, DoB: 1962-12-31 ( 1007)
-------

Request:

```
POST Patient

```

-------

Entry 2 - fullUrl = urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef

Resource Practitioner:

> **identifier**: 4654765876**name**: Akerman Philip Prof**address**: Castro Valley CA

Request:

```
POST Practitioner

```

-------

Entry 3 - fullUrl = urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d

Resource Specimen:

> **identifier**: 076e1948-2217-11e9-94d8-12e241dc1f66**status**: Available**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)

### Collections

| | |
| :--- | :--- |
| - | **Collector** |
| * | [Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef) |


Request:

```
POST Specimen

```

-------

Entry 4 - fullUrl = urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f

Resource Observation:

> 

Profile: [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)

**status**: Final**category**:Laboratory,Biomarker Category,Genetics**code**:Mutations/Megabase [# Ratio] in Tumor**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2019-03-05**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**: 25 Mutations/Megabase(Details: UCUM code1/1000000 = '1/1000000')**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Biomarker Category | molecular sequence adjacent category |


Request:

```
POST Observation

```

-------

Entry 5 - fullUrl = urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d

Resource Observation:

> 

Profile: [Variant](StructureDefinition-variant.md)

**status**: Final**category**:Laboratory,Genetics**code**:Genetic variant assessment**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2019-03-05**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**value**:Present**method**:Sequencing**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)
> **component****code**:Human reference sequence assembly version**value**:GRCh37

> **component****code**:Genomic DNA change (gHGVS)**value**:NC_000007.13:g.140453136A>T

> **component****code**:Discrete genetic variant**value**:Clinvar ID 13961

> **component****code**:Amino acid change (pHGVS)**value**:NP_004324.2:p.Val600Glu

> **component****code**:Gene studied ID**value**:BRAF

Request:

```
POST Observation

```

-------

Entry 6 - fullUrl = urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524

Resource Observation:

> 

Profile: [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)

**Related artifact**: No display for RelatedArtifact (type: justification; display: https://pmkb.weill.cornell.edu/therapies/103)**status**: Final**category**:Laboratory,Genetics**code**:Diagnostic Implication**subject**:[Carrot John Mr Male, DoB: 1962-12-31 ( 1007)](Bundle-bundle-oncology-diagnostic.md#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d)**effective**: 2019-03-05**performer**:[Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef)**method**:Computational analysis**specimen**:[Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d)**derivedFrom**:[Observation Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
> **component****code**:Genetic variation clinical significance [Imp]**value**:Pathogenic

> **component****code**:Level of Evidence**value**:Very strong evidence pathogenic

> **component****code**:Associated phenotype**value**:melanoma

Request:

```
POST Observation

```

-------

Entry 7 - fullUrl = urn:uuid:ad7a499b-a43b-4cc8-bf46-cac62d9ecae5

Resource DiagnosticReport:

> 

Profile: [Genomic Report](StructureDefinition-genomic-report.md)

## Genetic analysis report (Genetics ) 

| | |
| :--- | :--- |
| Subject | Carrot John Mr Male, DoB: 1962-12-31 ( 1007) |
| When For | 2019-03-05 |
| Performer | [Practitioner Akerman Philip Prof](Bundle-bundle-oncology-diagnostic.md#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef) |

**Report Details**

* **Code**: [Genetic variant assessment](Bundle-bundle-complexVariant-nonHGVS.md#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d)
  * **Value**: Present
  * **Flags**: Final
  * **Reported**: 2019-03-05 16:04:44+0000
* **Code**: [Diagnostic Implication](Bundle-bundle-oncology-diagnostic.md#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524)
  * **Value**: 
  * **Flags**: Final
  * **Reported**: 


Request:

```
POST DiagnosticReport

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bundle-oncology-diagnostic",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Inline-Instance-for-oncology-diagnostic-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Inline-Instance-for-oncology-diagnostic-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Inline-Instance-for-oncology-diagnostic-1</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-1\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-1\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "1007"
          }
        ],
        "name" : [
          {
            "given" : ["Carrot", "John", "Mr"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1962-12-31",
        "generalPractitioner" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Inline-Instance-for-oncology-diagnostic-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Inline-Instance-for-oncology-diagnostic-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Inline-Instance-for-oncology-diagnostic-2</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-2\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-2\"> </a><p><b>identifier</b>: 4654765876</p><p><b>name</b>: Akerman Philip Prof </p><p><b>address</b>: Castro Valley CA </p></div>"
        },
        "identifier" : [
          {
            "value" : "4654765876"
          }
        ],
        "name" : [
          {
            "given" : ["Akerman", "Philip", "Prof"]
          }
        ],
        "address" : [
          {
            "city" : "Castro Valley",
            "state" : "CA"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner"
      }
    },
    {
      "fullUrl" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "Inline-Instance-for-oncology-diagnostic-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_Inline-Instance-for-oncology-diagnostic-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen Inline-Instance-for-oncology-diagnostic-3</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-3\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-3\"> </a><p><b>identifier</b>: 076e1948-2217-11e9-94d8-12e241dc1f66</p><p><b>status</b>: Available</p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><h3>Collections</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Collector</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "076e1948-2217-11e9-94d8-12e241dc1f66"
          }
        ],
        "status" : "available",
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "collection" : {
          "collector" : {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Specimen"
      }
    },
    {
      "fullUrl" : "urn:uuid:40e85eda-4d31-4bd2-a5a0-c39d63f9824f",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-diagnostic-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/molecular-biomarker"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-diagnostic-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-diagnostic-4</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-4\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-molecular-biomarker.html\">Molecular Biomarker</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 94076-7}\">Mutations/Megabase [# Ratio] in Tumor</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2019-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: 25 Mutations/Megabase<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code1/1000000 = '1/1000000')</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs biomarker-category}\">Biomarker Category</span></td><td><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs molgen}\">molecular sequence adjacent category</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                "code" : "biomarker-category"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "94076-7",
              "display" : "Mutations/Megabase [# Ratio] in Tumor"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2019-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueQuantity" : {
          "value" : 25,
          "unit" : "Mutations/Megabase",
          "system" : "http://unitsofmeasure.org",
          "code" : "1/1000000"
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
                  "code" : "biomarker-category"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/molecular-biomarker-ontology-cs",
                  "code" : "molgen",
                  "display" : "molecular sequence adjacent category"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-diagnostic-5",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/variant"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-diagnostic-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-diagnostic-5</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-5\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-variant.html\">Variant</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2019-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26398-0}\">Sequencing</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 62374-4}\">Human reference sequence assembly version</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA14029-5}\">GRCh37</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81290-9}\">Genomic DNA change (gHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NC_000007.13:g.140453136A&gt;T}\">NC_000007.13:g.140453136A&gt;T</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81252-9}\">Discrete genetic variant</span></p><p><b>value</b>: <span title=\"Codes:{http://www.ncbi.nlm.nih.gov/clinvar 13961}\">Clinvar ID 13961</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48005-3}\">Amino acid change (pHGVS)</span></p><p><b>value</b>: <span title=\"Codes:{http://varnomen.hgvs.org NP_004324.2:p.Val600Glu}\">NP_004324.2:p.Val600Glu</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 48018-6}\">Gene studied ID</span></p><p><b>value</b>: <span title=\"Codes:{http://www.genenames.org HGNC:1097}\">BRAF</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69548-6",
              "display" : "Genetic variant assessment"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2019-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA9633-4",
              "display" : "Present"
            }
          ]
        },
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26398-0",
              "display" : "Sequencing"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "62374-4",
                  "display" : "Human reference sequence assembly version"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA14029-5",
                  "display" : "GRCh37"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81290-9",
                  "display" : "Genomic DNA change (gHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NC_000007.13:g.140453136A>T",
                  "display" : "NC_000007.13:g.140453136A>T"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81252-9",
                  "display" : "Discrete genetic variant"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.ncbi.nlm.nih.gov/clinvar",
                  "code" : "13961",
                  "display" : "Clinvar ID 13961"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48005-3",
                  "display" : "Amino acid change (pHGVS)"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://varnomen.hgvs.org",
                  "code" : "NP_004324.2:p.Val600Glu",
                  "display" : "NP_004324.2:p.Val600Glu"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48018-6",
                  "display" : "Gene studied ID"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.genenames.org",
                  "code" : "HGNC:1097",
                  "display" : "BRAF"
                }
              ]
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "Inline-Instance-for-oncology-diagnostic-6",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/diagnostic-implication"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_Inline-Instance-for-oncology-diagnostic-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation Inline-Instance-for-oncology-diagnostic-6</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-6\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-diagnostic-implication.html\">Diagnostic Implication</a></p></div><p><b>Related artifact</b>: No display for RelatedArtifact  (type: justification; display: https://pmkb.weill.cornell.edu/therapies/103)</p><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></p><p><b>subject</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-d0b4affa-91d6-46d1-af01-b30d9f16ef6d\">Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</a></p><p><b>effective</b>: 2019-03-05</p><p><b>performer</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></p><p><b>method</b>: <span title=\"Codes:{http://loinc.org LA26811-2}\">Computational analysis</span></p><p><b>specimen</b>: <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a5d6a6a9-4859-480e-85b2-56974fef3b9d\">Specimen: identifier = 076e1948-2217-11e9-94d8-12e241dc1f66; status = available</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\">Observation Genetic variant assessment</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 53037-8}\">Genetic variation clinical significance [Imp]</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA6668-3}\">Pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 93044-6}\">Level of Evidence</span></p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA30200-2}\">Very strong evidence pathogenic</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81259-4}\">Associated phenotype</span></p><p><b>value</b>: <span title=\"Codes:\">melanoma</span></p></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact",
            "valueRelatedArtifact" : {
              "type" : "justification",
              "display" : "https://pmkb.weill.cornell.edu/therapies/103"
            }
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs",
              "code" : "diagnostic-implication",
              "display" : "Diagnostic Implication"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2019-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "method" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA26811-2",
              "display" : "Computational analysis"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "53037-8",
                  "display" : "Genetic variation clinical significance [Imp]"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA6668-3",
                  "display" : "Pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "93044-6",
                  "display" : "Level of Evidence"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "LA30200-2",
                  "display" : "Very strong evidence pathogenic"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "81259-4"
                }
              ]
            },
            "valueCodeableConcept" : {
              "text" : "melanoma"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:ad7a499b-a43b-4cc8-bf46-cac62d9ecae5",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "Inline-Instance-for-oncology-diagnostic-7",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/genomics-reporting/StructureDefinition/genomic-report"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_Inline-Instance-for-oncology-diagnostic-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport Inline-Instance-for-oncology-diagnostic-7</b></p><a name=\"Inline-Instance-for-oncology-diagnostic-7\"> </a><a name=\"hcInline-Instance-for-oncology-diagnostic-7\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-genomic-report.html\">Genomic Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 51969-4}\">Genetic analysis report</span> (<span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0074 GE}\">Genetics</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Carrot John Mr  Male, DoB: 1962-12-31 ( 1007)</td></tr><tr><td>When For</td><td>2019-03-05</td></tr><tr><td>Performer</td><td> <a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-a48256f8-db37-44e0-a0f6-d7af16c7c9ef\">Practitioner Akerman Philip Prof </a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>Reported</b></td></tr><tr><td><a href=\"Bundle-bundle-complexVariant-nonHGVS.html#urn-uuid-16fdd5fc-e665-48af-99e4-48d603f3e12d\"><span title=\"Codes:{http://loinc.org 69548-6}\">Genetic variant assessment</span></a></td><td><span title=\"Codes:{http://loinc.org LA9633-4}\">Present</span></td><td>Final</td><td>2019-03-05 16:04:44+0000</td></tr><tr><td><a href=\"Bundle-bundle-oncology-diagnostic.html#urn-uuid-1bf9642d-fd1c-4819-8c5d-44fae4bad524\"><span title=\"Codes:{http://hl7.org/fhir/uv/genomics-reporting/CodeSystem/tbd-codes-cs diagnostic-implication}\">Diagnostic Implication</span></a></td><td/><td>Final</td><td/></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
                "code" : "GE"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51969-4"
            }
          ],
          "text" : "Genetic analysis report"
        },
        "subject" : {
          "reference" : "urn:uuid:d0b4affa-91d6-46d1-af01-b30d9f16ef6d"
        },
        "effectiveDateTime" : "2019-03-05",
        "performer" : [
          {
            "reference" : "urn:uuid:a48256f8-db37-44e0-a0f6-d7af16c7c9ef"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:a5d6a6a9-4859-480e-85b2-56974fef3b9d"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:16fdd5fc-e665-48af-99e4-48d603f3e12d",
            "display" : "BRAF V600E mutation observed"
          },
          {
            "reference" : "urn:uuid:1bf9642d-fd1c-4819-8c5d-44fae4bad524",
            "display" : "melanoma implicated"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "DiagnosticReport"
      }
    }
  ]
}

```
