# About - Security for Scalable Registration, Authentication, and Authorization v2.0.0

* [**Table of Contents**](toc.md)
* **About**

## About

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Package File

The following package file includes an NPM package file used by many FHIR tools. It includes all the value sets, profiles, extensions, list of pages and urls in the IG, etc. for this version of the Implementation Guide. This file should be the first choice when generating any implementation artifacts as it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the contents of this specification and the applicable profiles in order to make a conformant implementation. See the overview on validating [FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html):

[Package](package.tgz)

### Downloadable Copy of Entire Specification

The following ZIP file contains a downloadable version of this IG that can be hosted locally: [Downloadable Copy](full-ig.zip)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.udap-security.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.udap-security.r4b)](package.r4b.tgz) are available.

### Dependency Table

### Globals Table

*There are no Global profiles defined*

### Notices

HL7®, FHIR®, the HL7® logo, and the FHIR® flame design are registered trademarks of Health Level Seven International. UDAP™ and the gear design are trademarks of UDAP.org. No use of external IP

### Credits

Editor: Luis C. Maas, EMR Direct and UDAP.org

This implementation guide was made possible by the thoughtful contributions and feedback of the following people and organizations:

The members of the ONC FHIR at Scale Taskforce (FAST) Security Tiger Team
 The members of the HL7/UDAP.org joint project working group
 The members of the HL7 Security Work Group

