# Consumer-Facing - Security for Scalable Registration, Authentication, and Authorization v2.0.0

* [**Table of Contents**](toc.md)
* **Consumer-Facing**

## Consumer-Facing

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This guide supports consumer-facing client applications using the authorization code grant type.

Consumer-facing client applications **SHALL** obtain an access token for access to FHIR resources by following the OAuth 2.0 authorization code grant flow, with the additional options and constraints discussed below.

### Obtaining an authorization code

The workflow for obtaining an authorization code is summarized in the following diagram: 

Client applications **SHALL** request an authorization code as per [Section 4.1.1](https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.1) of RFC 6749, with the following additional constraints. Client applications and servers **MAY** optionally support UDAP Tiered OAuth for User Authentication to allow for cross-organizational or third party user authentication as described in [Section 6](user.md).

Servers **SHALL** handle and respond to authorization code requests as per [Section 4.1.2](https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2) of RFC 6749.

Client applications and Authorization Servers **SHALL** conform to the additional constraints for authorization code flow found in [Section 7.2](general.md#authorization-code-flow) of this guide.

### Obtaining an access token

The workflow for obtaining an access token is summarized in the following diagram: 

Client applications **SHALL** exchange authorization codes for access tokens as per [Section 4.1.3](https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.3) of RFC 6749, with the following additional options and constraints.

Client applications **SHALL** include a `code_verifier` parameter and value in the token request as per Section 4.5 of RFC 7636.

#### Constructing Authentication Token

Client apps following this guide will have registered to authenticate using a private key rather than a shared `client_secret`. Thus, the client **SHALL** use its private key to sign an Authentication Token as described in this section, and include this JWT in the `client_assertion` parameter of its token request as described in [Section 5.1](https://www.udap.org/udap-jwt-client-auth-stu1.html#section-5.1) of UDAP JWT-Based Client Authentication and detailed further in [Section 4.2.2](consumer.md#submitting-a-token-request) of this guide.

Authentication Tokens submitted by client apps **SHALL** conform to the general JWT header requirements above and **SHALL** include the following parameters in the JWT claims defined in [Section 4](https://www.udap.org/udap-jwt-client-auth-stu1.html#section-4) of UDAP JWT-Based Client Authentication:

| | | |
| :--- | :--- | :--- |
| `iss` | required | The application's`client_id`as assigned by the Authorization Server during the registration process |
| `sub` | required | The application's`client_id`as assigned by the Authorization Server during the registration process |
| `aud` | required | The FHIR Authorization Server's token endpoint URL |
| `exp` | required | Expiration time integer for this authentication JWT, expressed in seconds since the "Epoch" (1970-01-01T00:00:00Z UTC). |
| `iat` | required | Issued time integer for this authentication JWT, expressed in seconds since the "Epoch" |
| `jti` | required | A nonce string value that uniquely identifies this authentication JWT. See[Section 7.1.4](general.md#jwt-claims)for additional requirements regarding reuse of values. |

The maximum lifetime for an Authentication Token **SHALL** be 5 minutes, i.e. the value of `exp` minus the value of `iat` **SHALL NOT** exceed 300 seconds. The Authorization Server **MAY** ignore any unrecognized claims in the Authentication Token. The Authentication Token **SHALL** be signed and serialized using the JSON compact serialization method.

#### Submitting a token request

Client applications **SHALL** submit a POST request to the Authorization Server’s token endpoint containing the following parameters as per [Section 5.1](https://www.udap.org/udap-jwt-client-auth-stu1.html#section-5.1) of UDAP JWT-Based Client Authentication. Client apps authenticating in this manner **SHALL NOT** include an HTTP Authorization header or client secret in the token request. The token request **SHALL** include the following parameters:

| | | |
| :--- | :--- | :--- |
| `grant_type` | required | Fixed value:`authorization_code` |
| `code` | required | The code that the app received from the Authorization Server |
| `redirect_uri` | conditional | The client application's redirection URI. This parameter**SHALL**be present only if the`redirect_uri`parameter was included in the authorization request in Section 4.1, and their values**SHALL**be identical. |
| `client_assertion_type` | required | Fixed value:`urn:ietf:params:oauth:client-assertion-type:jwt-bearer` |
| `client_assertion` | required | The signed Authentication Token JWT |
| `udap` | required | Fixed value:`1` |

#### Server processing of token requests

An Authorization Server receiving token requests containing Authentication Tokens as above **SHALL** validate and respond to the request as per [Sections 6 and 7](https://www.udap.org/udap-jwt-client-auth-stu1.html#section-6) of UDAP JWT-Based Client Authentication.

The Authorization Server **SHALL** return an error as per Section 4.6 of RFC 7636 if the client included a `code_challenge` in its authorization request but did not include the correct `code_verfier` value in the corresponding token request.

For all successful token requests, the Authorization Server **SHALL** issue access tokens with a lifetime no longer than 60 minutes.

This guide does not currently constrain the type or format of access tokens issued by Authorization Servers. Note that other implementation guides (e.g. SMART App Launch, IUA, etc.), when used together with this guide, may limit the allowed access token types (e.g. Bearer) and/or formats (e.g. JWT).

### Refresh tokens

This guide supports the use of refresh tokens, as described in [Section 1.5 of RFC 6749](https://datatracker.ietf.org/doc/html/rfc6749#section-1.5). Authorization Servers **MAY** issue refresh tokens to consumer-facing client applications as per [Section 5 of RFC 6749](https://datatracker.ietf.org/doc/html/rfc6749#section-5). Client apps that have been issued refresh tokens **MAY** make refresh requests to the token endpoint as per [Section 6 of RFC 6749](https://datatracker.ietf.org/doc/html/rfc6749#section-6). Client apps authenticate to the Authorization Server for refresh requests by constructing and including an Authentication Token in the same manner as for initial token requests.

