# Testing and Conformance - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Testing and Conformance

This chapter describes testing data and testing plan, and provide some samples for developers.

1. [Test Plan](#testplan)- Test plans for different actors
1. [Test Data](#testdata)- Test data that can be used
1. [Resources Samples](#samples)- Samples of resources profiled following this IG

### Test Plan

#### Scenario 1: RDSR summary to FHIR

##### Actors

* Radiation Dose Summary Producer (RDSP) actor
* FHIR server
* Radiation Dose Summary Consumer (RDSC) actor

##### Roles

| | |
| :--- | :--- |
| Radiation Dose Summary Producer (RDSP) actor | Produce the Radiation Dose Summary resource |
| FHIR server | Host and Manage the Radiation Dose Summary resourceManage the contextual resources (Patient, Device, ImagingStudy, etc.) |
| Radiation Dose Summary Consumer (RDSC) actor | Consume Radiation Dose Summary resource(O) Produce Radiation Summary Report |

##### Steps

Here are the different steps that needs to be performed: ![](./seq.svg)

* The RDSP actor gathers an RDSR from an irradiating modality (a CT RDSR, an X-Ray RDSR or an RRDSR)
* The RDSP actor collects the identifiers of the Patient, the Device, the Practitioner, and the ImagingStudy from the FHIR Server
* The RDSP actor constructs the Radiation Dose Summary resource and POST it to the FHIR server
* The RDSC actor queries the FHIR server and collects radiation summary information
* Optionally, the RDSC actor enhances the FHIR server with the Radiation Summary Report.

##### Validation

* The generated Radiation Summary resources shall pass the validation tool testing, using the FHIR [validator](https://github.com/hapifhir/org.hl7.fhir.core/releases/latest/download/validator_cli.jar)
* The sharing of the Radiation Dose Summary resources from the RDSP actor to the FHIR server can be validated through the test script [TestScript_RDS_Sharing_Verification](TestScript-RDS-sharing-verification.md)
* The accessibility of the FHIR server through searching capabilities can be validated with the test script [TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md)
* The capacity of the FHIR server to accept transactions with the Bundle of resources of Radiation Dose Summary can be tested with the test script [TestScript_RDSP_Simulator](TestScript-RDSP-Simulator.md)

#### Scenario 2: Grouping RDSP and FHIR Server

##### Actors

* Radiation Dose Summary Producer (RDSP) actor *grouped with* FHIR server
* Radiation Dose Summary Consumer (RDSC) actor

##### Roles

| | |
| :--- | :--- |
| Radiation Dose Summary Producer (RDSP) actor grouped with FHIR server | Produce internally the Radiation Dose Summary resourceHost and Manage the Radiation Dose Summary resourceManage the contextual resources (Patient, Device, ImagingStudy, etc.) |
| Radiation Dose Summary Consumer (RDSC) actor | Consume Radiation Dose Summary resource |

##### Steps

Here are the different steps that needs to be performed: ![](./seq2.svg)

* The (RDSP actor, FHIR server) gathers an RDSR from an irradiating modality (a CT RDSR, an X-Ray RDSR or an RRDSR)
* The (RDSP actor, FHIR server) constructs and exposes the resources related to the Patient, ImagingStudy, Practitioner, Device and Radiation Dose Summary resources.
* The RDSC actor queries the (RDSP actor, FHIR server) and collects radiation summary information

##### Validation

* The generated Radiation Summary resources shall pass the validation tool testing, using the FHIR [validator](https://github.com/hapifhir/org.hl7.fhir.core/releases/latest/download/validator_cli.jar)
* The accessibility of the FHIR server through searching capabilities can be validated with the test script [TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md)

### Test Data

Some RDSRs and RRDSRs can be downloaded from IHE google drive, and can be used in the generation of the Radiation Dose Summary resources. Here are the links to these DICOM objects:

* [REM samples (CT RDSRs and X-Ray RDSRs)](https://drive.google.com/drive/u/0/folders/1M3OLxdHU25q8vNKQSr-O3Aip__YOYly0)
* [REM-NM samples (RRDSRs)](https://drive.google.com/drive/u/0/folders/1fE1BGXQDhqjzTbESt38qtiJ1Q7Js6Gg3)

Also, examples of RDSRs and RRDSRs can be accessed through the IHE Connectathon Samples sharing.

### Resources samples

#### Radiation Dose Summary Consumer search query samples

Here are some examples of queries and searching use cases that can be performed by the RDSC actor:

| | |
| :--- | :--- |
| Search all the Dose summaries within the FHIR Server | GET /fhir/Observation?code=73569-6 |
| View specific Dose Summary | GET /fhir/Observation/19 |
| Access Device dose summaries | GET /fhir/Observation?code=73569-6&device=22   |
| Search Dose Summary of a patient through the last year | GET /fhir/Observation?code=73569-6&patient=8&date=gt2020-01-01 |
| Search Dose Summary related to the study | GET /fhir/Observation?code=73569-6&part-of=1232 |

#### Radiation Dose Summary Profile samples

##### CT sample

Here is an example of the Radiation Dose Summary Profile resource related to CT exam, and its dependencies:

![](./example1.svg)

* [RadiationDoseSummary-139](Observation-139.md)
* [ImagingStudy-342](ImagingStudy-342.md)
* [Patient-56](Patient-56.md)
* [Practitioner-33](Practitioner-33.md)
* [ModalityDevice-539](Device-539.md)

A sample of Dose Summary Report profile exists with relationship to Indications profile and Pregnancy Status:

* [RadiationSummaryReport-1](Composition-1.md)
* [Indications-1](Observation-34.md)
* [PregnancyStatus-1](Observation-33.md)

##### X-Ray sample

Here is an example of the Radiation Dose Summary Profile resource related to XA exam, and its dependencies:

![](./example2.svg)

* [RadiationDoseSummary-545](Observation-545.md)
* [ImagingStudy-344](ImagingStudy-344.md)
* [Patient-56](Patient-56.md)
* [Practitioner-33](Practitioner-33.md)
* [ModalityDevice-12](Device-12.md)

##### NM sample

Here is an example of the Radiation Dose Summary Profile resource related to Radiopharmaceutical administration, and its dependencies:

![](./example3.svg) 

* [RadiationDoseSummary-122](Observation-122.md)
* [ImagingStudy-22](ImagingStudy-22.md)
* [Patient-56](Patient-56.md)
* [Practitioner-33](Practitioner-33.md)

