# hl7.fhir.uv.radiation-dose-summary#1.0.0: Radiation Dose Summary for Diagnostic Procedures on FHIR(en)

## Pages

* [Home](index.md)
* [Architecture and Implementation](archi.md)
* [Background](background.md)
* [Testing and Conformance](testing.md)
* [Downloads](downloads.md)
* [Artifacts Summary](artifacts.md)

## Resources

### CodeSystems

* [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md)

### ValueSets

* [Radiation Dose Summary component type](ValueSet-component-radiation-dose-summary-vs.md)
* [Isotopes Value Set](ValueSet-isotope-rds-vs.md)
* [Procedure Reported Type Value Set](ValueSet-procedure-reported-type-rds-vs.md)
* [Radiopharmaceuticals Value Set](ValueSet-radiopharmaceutical-rds-vs.md)

### Resource Profiles

* [Indication Observation](StructureDefinition-indication-observation.md)
* [Modality Device](StructureDefinition-modality-device.md)
* [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)
* [Radiation Summary Report](StructureDefinition-radiation-summary-report.md)

### Bundles

* [Bundle-RDS-resources](Bundle-Bundle-RDS-resources.md)

### CapabilityStatements

* [FHIR Server supporting FHIR operations in order to interact with RDSC Actor](CapabilityStatement-FHIRServer-RDSC.md)
* [FHIR Server supporting FHIR operations in order to interact with RDSP Actor](CapabilityStatement-FHIRServer-RDSP.md)
* [FHIR Server supporting FHIR operations in order to interact with RDSC and RDSP Actors](CapabilityStatement-FHIRServer.md)
* [RDSC Actor requirements](CapabilityStatement-RDSC.md)
* [RDSP Actor minimal requirements](CapabilityStatement-RDSP.md)

### ImplementationGuides

* [Radiation Dose Summary for Diagnostic Procedures on FHIR](ImplementationGuide-hl7.fhir.uv.radiation-dose-summary.md)

### TestScripts

* [TestScript_RDS_Sharing_Verification](TestScript-RDS-sharing-verification.md)
* [TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md)
* [TestScript_RDSP_Simulator](TestScript-RDSP-Simulator.md)

### Examples

* [Radiation exposure and protection information (Composition)](Composition-1.md)
* [12 (Device)](Device-12.md)
* [539 (Device)](Device-539.md)
* [22 (ImagingStudy)](ImagingStudy-22.md)
* [342 (ImagingStudy)](ImagingStudy-342.md)
* [344 (ImagingStudy)](ImagingStudy-344.md)
* [122 (Observation)](Observation-122.md)
* [139 (Observation)](Observation-139.md)
* [33 (Observation)](Observation-33.md)
* [34 (Observation)](Observation-34.md)
* [545 (Observation)](Observation-545.md)
* [56 (Patient)](Patient-56.md)
* [33 (Practitioner)](Practitioner-33.md)
