# Architecture and Implementation - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Architecture and Implementation

This chapter describes the different architecture aspects of the resources, profiles and actors identified within the IG.

1. [Profiles & Extensions](#profiles)- FHIR Profiles and extensions defined in the IG
1. [Actors](#actors)- Actors participating in the IG
1. [Terminology](#terminology)- Value Sets defined
1. [Resources Identifiers](#identifiers)- A focus on DICOM identifiers types
1. [Conformance](#conformance)- A focus on the conformance with this IG
1. [Security Consideration](#sec)- Security aspects to be taken in consideration

### Profiles & Extensions

#### Resource Profiles

* [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) profiles the Observation resource to provide the structure for the Radiation Dose Summary reporting.
* [Radiation Summary Report](StructureDefinition-radiation-summary-report.md) profiles Composition resource and defines a report document describing the irradiation act.
* [Indication Observation](StructureDefinition-indication-observation.md) profiles Observation resource to provide the indications related to the performed procedure.
* [Pregnancy Status (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-status-uv-ips.html) profiles Observation resource to provide the pregnancy status of the patient. The Pregnancy Status profile is defined within the [International Patient Summary IG (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/).
* [Modality Device](StructureDefinition-modality-device.md) profiles Device resource to provide the specificity of a modality as a Device resource.

#### Supporting DataType Profiles 

There is no special supporting DataType profiles defined by this IG.

#### Supporting Extensions

There is no special supporting extensions defined by this IG.

#### Profiles relationship

![](./archi.svg)

There are two levels or profiles:

* Radiation Observation profile: This profile allows for the description of a performed radiation act, summarizing the radiation report generated by the modality. See [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) in the class diagram above.
* Radiation Report profiles: These profiles reference the radiation observation resources and enhance the collected information in a general radiation report by relating it to the patient's conditions and the procedure indications. See [Radiation Summary Report](StructureDefinition-radiation-summary-report.md), [Indication Observation](StructureDefinition-indication-observation.md), and [Pregnancy Status (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/StructureDefinition-Observation-pregnancy-status-uv-ips.html) in the class diagram above. The latter two profiles contain information collected before the patient's imaging procedure, explaining the two levels of profiles.

A general [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) provides a summary of an irradiation act related to a performed procedure and specific equipment. This profile allows the reporting of radiation data as structured text within its valueString element. The structure of the text included in valueString is site-dependent.

 Radiation Dose Summary profiles are using the component element to describe the different parameters of the radiation procedure. We consider that the attributes of the components in the radiation summary resources are part of the resource itself when provided, which cannot be understood without reading the complete different components. Having different Observations referenced in multiple hasMember elements is not useful, as the interpretation of the radiation dose summary resource needs to access to all the different parameters of the radiation procedure.

### Actors

A list of actors are identified within this IG:

* Radiation Dose Summary Producer
* FHIR Server
* Radiation Dose Summary Consumer

![](./actors.svg)

#### Radiation Dose Summary Producer

The Radiation Dose Summary Producer (RDSP) is responsible for creating the Radiation Dose Summary observation and sharing it with the FHIR Server. The RDSP should synchronize multiple resources with the FHIR Server to avoid duplicating resources. For example, the RDSP should verify if the patient already exists in the FHIR Server; if the patient does exist, only a reference to the patient should be created. In this case, the POST bundle to the FHIR Server should not contain a Patient resource.

Generally, this actor can be implemented within a Dose Management System.

The RDSP should implement the following CapabilityStatement: [RDSP capability statement](CapabilityStatement-RDSP.md).

The RDSP actor SHALL adhere to the security considerations in the [security](archi.md#security-consideration) section. Sharing PHI SHALL comply with the local security requirements of the deploying facility.

#### FHIR Server

The FHIR Server has two functions:

1. Provide the diagnostic procedure context to both the Radiation Dose Summary Producer and Consumer actors
1. Store the Radiation Dose Summary resources and Irradiation Event resources from the Radiation Dose Summary Producer actor

Thus, the FHIR Server can be divided in fact in two sub-actors: one to provide the contextual resources, and one for the Radiation Dose resources.

The contextual resources are resources managed by the FHIR Server and related to the imaging procedure, and works as a source of truth for these resources:

1. Patient: the subject of the imaging study.
1. Device: the modality.
1. Practitioner: the irradiation authorizing persons responsible on the performed exams.
1. ImagingStudy: resources describing the performed exams.

When these resources are not present in the FHIR Server, the Radiation Dose Summary Producer can complement the FHIR Server by creating observations from the RDSRs and images collected from modalities.

The FHIR Server is a logical actor which could be part of an EHR related to the patient care. Also, it can be part of the Dose Management System, used to expose radiation summary to third party consumers.

The FHIR Server can implement the following CapabilityStatements:

* [FHIRServer-RDSP](CapabilityStatement-FHIRServer-RDSP.md) - Requirements for FHIR Server interacting with RDSP actor
* [FHIRServer-RDSC](CapabilityStatement-FHIRServer-RDSC.md) - Requirements for FHIR Server interacting with RDSC actor
* [FHIRServer](CapabilityStatement-FHIRServer.md) - Requirements for FHIR Server actor

The FHIR Server SHALL follow the different security considerations mentioned in [security](archi.md#security-consideration) section.

#### Radiation Dose Summary Consumer

The Radiation Dose Summary Consumer (RDSC) actor is responsible for retrieving the Radiation Dose Summary observation (e.g., a RIS or EHR may enhance the final radiology report with radiation information).

Specialized expertise is required to understand radiation dose data. The interpretation of the radiation information collected by the Radiation Dose Summary Consumer SHALL follow the local policies and jurisdictional requirements to avoid misuse.

The RDSC actor can implement the following CapabilityStatement: [RDSC capability statement](CapabilityStatement-RDSC.md).

The RDSC actor SHALL follow the different security considerations mentioned in [security](archi.md#security-consideration) section. Collection of Data from the FHIR Server SHALL follow consent requirements used within the deploying facility, as described in [security](archi.md#security-consideration) section.

#### Actor grouping

The FHIR Server can be grouped with the Radiation Dose Summary Producer actor within the Dose Management System. Thus, the Dose Management System is managing all the resources and references between resources. Another possible grouping is between the FHIR Server and the Radiation Dose Summary Consumer actor (e.g., within EHR systems or RIS/EHR systems). In this case, the source of truth for contextual resources are independent from the Radiation Dose Summary Producer.

#### Actor communication

The following sequence diagram describes the typical workflow between the RDSP actor, the FHIR Server, and the RDSC actor.

![](./seq-simplified.svg)

In this workflow, a patient undergoes an irradiating study (including a nuclear medicine administration). The detailed radiation information is shared with the Radiation Dose Summary Producer actor, which may be a Dose Management System. During the process of creating the Radiation Dose Summary resources, the RDSP actor makes queries to the FHIR Server in order to collect the correct IDs to be referred in the newly created resources (i.e., Patient, Practitioner, Modality, and ImagingStudy resources). Many of these resources can be found within the DICOM RDSR provided by the modality. Some identifiers within the RDSR can be used for querying the FHIR Server. Below is a mapping illustrating the relationship between the FHIR resources and the DICOM identifiers:

| | |
| :--- | :--- |
| Patient | tag(0010,0020) Patient ID |
| Practitioner | TID 1020(Person Participant).EV (113871, DCM, Person ID) |
| ImagingStudy | tag(0020,000D) Study Instance UID |
| Device | tag(0018,1000) Device Serial Number |

The IDs collected are used to construct the Radiation Dose Summary resources and their related Irradiation Event resources. Then, these resources are shared with the FHIR Server through a POST of a bundle. The bundle may contain temporary resources related to Patient, ImagingStudy, and other contextual resources, if the FHIR Server has no reference of them.

Once the resources are shared with the FHIR Server, the Radiation Dose Summary Consumer can search and retrieve the resources from the FHIR Server. The RDSC actor can optionally enrich the FHIR Server resources by posting a Composition document as profiled by the Radiation Summary Report profile.

### Terminology

#### Value Sets Defined

These Value Sets have been defined for this implementation guide.

1. [Isotopes Value Set](ValueSet-isotope-rds-vs.md)
1. [Procedure Reported Type Value Set](ValueSet-procedure-reported-type-rds-vs.md)
1. [Radiopharmaceuticals Value Set](ValueSet-radiopharmaceutical-rds-vs.md)
1. [Radiation Dose Summary component type](ValueSet-component-radiation-dose-summary-vs.md)

#### Value Sets Used

DICOM ValueSet links:

1. [CID 4030 CT, MR and PET Anatomy Imaged](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4030.html)
1. [CID 4052 Phantom Devices](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4052.html)
1. [CID 33 Modality](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_33.html)
1. [CID 11 Route of Administration](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_11.html)
1. [CID 25 Radiopharmaceuticals](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_25.html)
1. [CID 4021 PET Radiopharmaceutical](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4021.html)
1. [CID 18 Isotopes in Radiopharmaceuticals](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_18.html)
1. [CID 4020 PET Radionuclide](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4020.html)

#### Code Systems Defined

One new code system is defined under this IG:

1. [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md)

#### Code Systems Used

This implementation guide draws on a number of formal code systems.

The following table presents the external code systems (and naming conventions) adopted in this implementation guide:

| | | | |
| :--- | :--- | :--- | :--- |
| LOINC | Logical Observation Identifiers Names and Codes | http://loinc.org | Observation and laboratory codes |
| SNOMED CT | Systematized Nomenclature of Medicine Clinical Terms | http://snomed.info/sct | Procedures, anatomy, products, isotopes |
| DCM | DICOM | http://dicom.nema.org/resources/ontology/DCM | Devices, products, radiation information |

#### Value Sets strength

The following table summarizes the mapping between defined profiles and Value sets strength:

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Modality Device | type | [CID 33 Modality](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_33.html) | required | VS contains the exhaustive list of modality types |
| Radiation Dose Summary | component.code | [Components' Code for Radiation Dose Summary](ValueSet-component-radiation-dose-summary-vs.md) | extensible | to keep the possibility to extend the list of reported components |
| Radiation Dose Summary | component:procedureReported | [Procedure Reported Type Value Set](ValueSet-procedure-reported-type-rds-vs.md) | required | procedure reported component is the differentiator of irradiation type |

### Resources Identifiers

Many profiles defined in this IG are using DICOM IDs and UIDs as identifiers for the resources. In this paragraph, we summarize the different IDs and UIDs used, and the way they should be exposed in FHIR resources:

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Modality Device](StructureDefinition-modality-device.md) | identifier:deviceSerialNumber |   | SNO | [HL7 IdentifierType](http://terminology.hl7.org/CodeSystem/v2-0203) | Serial Number | (0018,1000) Device Serial Number |
| [Modality Device](StructureDefinition-modality-device.md) | identifier:aeTitle |   | application-entity | [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md) | Application Entity | N/A |
| [Modality Device](StructureDefinition-modality-device.md) | identifier:deviceUID | urn:dicom:uid | device-uid | [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md) | Device UID | (0018,1002) Device UID |
| [Modality Device](StructureDefinition-modality-device.md) | identifier:deviceID |   | device-id | [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md) | Device ID | (0018,1003) Device ID |
| [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) | identifier:radiationSRUID | urn:dicom:uid | sop-instance-uid | [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md) | SOP Instance UID | (0008,0018) SOP Instance UID |
| [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) | partOf.identifier | urn:dicom:uid | study-instance-uid | [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md) | Study Instance UID | (0020,000D) Study Instance UID |
| [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md) | basedOn.identifier |   | ACSN | [HL7 IdentifierType](http://terminology.hl7.org/CodeSystem/v2-0203) | Accession ID | (0008,0050) Accession Number |

Following the notes within the [ImagingStudy](http://hl7.org/fhir/imagingstudy.html#notes) resource - *When encoding a DICOM UID in an Identifier datatype, use the Identifier system of "urn:dicom:uid"* - the identifiers related to DICOM tags having the Value Representation (VR) of type UID, SHALL have the `type.system=urn:dicom:uid`.

Here some examples :

* Irradiation Event UID :

```

"identifier": [
    {
        "type": {
            "coding": [
                {
                    "system": "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
                    "code": "irradiation-event-uid",
                    "display": "Irradiation Event UID"
                }
            ]
        },
        "system": "urn:dicom:uid",
        "value": "urn:oid:1.2.840.121.3.32.0.1.1323423.2"
    }
]

```

* Application Entity :

```

"identifier": [
    {
        "type": {
            "coding": [
                {
                    "system": "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
                    "code": "application-entity",
                    "display": "Application Entity"
                }
            ]
        },
        "value": "XA01"
    }
]

```

### Conformance

#### Conventions

This implementation guide uses specific terminology to flag statements that have relevance for the evaluation of conformance with the guide:

* **SHALL** indicates requirements that must be met to be conformant with the specification.
* **SHOULD** indicates behaviors that are strongly recommended (and which may result in interoperability issues or sub-optimal behavior if not adhered to), but which do not, for this version of the specification, affect the determination of specification conformance.
* **MAY** describes optional behaviors that are free to consider but where the is no recommendation for or against adoption.

#### Claiming Conformance

Actors and Systems asserting conformance to this implementation guide have to implement the requirements outlined in the corresponding capability statements. The following definition of MUST SUPPORT is to be used in the implementation of the requirements.

#### Must Support

In the context of this IG, mustSupport on any data element SHALL be interpreted as follows:

* When creating Radiation Dose Summary content, implementers SHALL be capable of including mustSupport data elements.
* When receiving Radiation Dose Summary content, implementers: 
* SHALL be capable of processing resource instances containing mustSupport data elements without generating an error or causing the application to fail.
* SHOULD be capable of displaying mustSupport data elements for human use, or processing (e.g., storing) them for other purposes.
 

### Security Consideration

Exchanging Radiation summary resources makes use of patient-specific information which could be exploited by malicious actors resulting in exposure of patient data. For these reasons, all data exchange between the different actors must be secured appropriately with access to limited authorized individuals, data protected in transit, and appropriate audit measures taken.

Implementers SHOULD be aware of these [security considerations](http://hl7.org/fhir/R4/security.html) associated with FHIR transactions, particularly those related to:

* [Communications](http://hl7.org/fhir/R4/security.html#http)
* [Authentication](http://hl7.org/fhir/R4/security.html#authentication)
* [Authorization/Access Control](http://hl7.org/fhir/R4/security.html#authorization/access%20control)
* [Audit Logging](http://hl7.org/fhir/R4/security.html#audit%20logging)
* [Digital Signatures](http://hl7.org/fhir/R4/security.html#digital%20signatures)
* [Security Labels](http://hl7.org/fhir/R4/security-labels.html)
* [Narrative](http://hl7.org/fhir/R4/security.html#narrative)

These security requirements are highlighted in the context of this IG:

* Systems **SHALL** keep audit logs of the various transactions. Some auditing workflows can be used like IHE ATNA or RESTful ATNA.
* Systems **SHALL** use TLS version 1.2 or higher for all transmissions not taking place over a secure network connection. IHE ATNA may be followed for the TLS usage.
* Systems **SHALL** conform to FHIR [Communications Security requirements](http://hl7.org/fhir/R4/security.html#http).
* Systems **SHALL** implement consent requirements per their country, state, local, and institutional policies.

