# Radiation Dose Summary component type - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## ValueSet: Radiation Dose Summary component type 

 
Value Set describing the list of minimal dose information related to Procedure and Administration level 

 **References** 

* [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem DICOM Controlled Terminology Definitions v2025.2.20250411 (CodeSystem)](http://dicom.nema.org/resources/ontology/DCM)
* SNOMED CT International edition 01-Feb 2025

This value set contains 13 concepts

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "component-radiation-dose-summary-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/ValueSet/component-radiation-dose-summary-vs",
  "version" : "1.0.0",
  "name" : "ComponentRadiationDoseSummaryVS",
  "title" : "Radiation Dose Summary component type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-29T17:37:08+00:00",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "Value Set describing the list of minimal dose information related to Procedure and Administration level",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement.",
  "compose" : {
    "include" : [
      {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "version" : "2025.2.20250411",
        "concept" : [
          {
            "code" : "113813",
            "display" : "CT Dose Length Product Total"
          },
          {
            "code" : "113725",
            "display" : "Dose (RP) Total"
          },
          {
            "code" : "111637",
            "display" : "Accumulated Average Glandular Dose"
          },
          {
            "code" : "113722",
            "display" : "Dose Area Product Total"
          },
          {
            "code" : "113726",
            "display" : "Fluoro Dose Area Product Total"
          },
          {
            "code" : "113727",
            "display" : "Acquisition Dose Area Product Total"
          },
          {
            "code" : "113730",
            "display" : "Total Fluoro Time"
          },
          {
            "code" : "113731",
            "display" : "Total Number of Radiographic Frames"
          },
          {
            "code" : "113507",
            "display" : "Administered activity"
          },
          {
            "code" : "123005",
            "display" : "Radiopharmaceutical Volume"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "349358000",
            "display" : "Radiopharmaceuticals"
          },
          {
            "code" : "89457008",
            "display" : "Radioisotope"
          },
          {
            "code" : "410675002",
            "display" : "Route of administration"
          }
        ]
      }
    ]
  }
}

```
