# TestScript_RDSP_Simulator - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## TestScript: TestScript_RDSP_Simulator 

 
TestScript to validate the FHIR Server capabilities against an RDSP actor. 

**StructureDefinition Work Group**: ii

**url**: [TestScript TestScript_RDSP_Simulator](TestScript-RDSP-Simulator.md)

**version**: 1.0.0

**name**: TestScript_RDSP_Simulator

**status**: Active

**date**: 2021-07-17

**publisher**: HL7 International / Imaging Integration

**contact**: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), HL7 Imaging Integration Workgroup: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), Abderrazek Boufahja: [abderrazek.boufahja@gehealthcare.com](mailto:abderrazek.boufahja@gehealthcare.com)

**description**: 

TestScript to validate the FHIR Server capabilities against an RDSP actor.

**jurisdiction**: Global (Whole world)

**copyright**: 

HL7 2021

### Destinations

| | | |
| :--- | :--- | :--- |
| - | **Index** | **Profile** |
| * | 1 | [Test script profile destination type FHIR-Server](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-profile-destination-types.html#testscript-profile-destination-types-FHIR-Server): FHIR Server |

> **fixture**
> **id**rds-post-json
**autocreate**: false**autodelete**: false**resource**:[Bundle: type = transaction](Bundle-Bundle-RDS-resources.md)

> **variable****name**: rdsResourceId**path**: Bundle/entry/resource/Observation/id**sourceId**: bundle-post-response

> **variable****name**: patientResourceId**path**: Bundle/entry/resource/Patient/id**sourceId**: bundle-post-response

> **variable****name**: deviceResourceId**path**: Bundle/entry/resource/Device/id**sourceId**: bundle-post-response

> **variable****name**: practitionerResourceId**path**: Bundle/entry/resource/Practitioner/id**sourceId**: bundle-post-response

> **variable****name**: imagingStudyResourceId**path**: Bundle/entry/resource/ImagingStudy/id**sourceId**: bundle-post-response

> **test****name**: RDS-Queries-verification-POST**description**: This is a Test to validate the FHIR server capabilities according to Radiation Dose Summary searching possibilities.
> **action**

### Operations

| | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Description** | **Accept** | **ContentType** | **Destination** | **EncodeRequestUrl** | **ResponseId** | **SourceId** |
| * | [Test script operation code transaction](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-transaction): Transaction | Submit a bundle of resources creating the radiation dose summary | json | json | 1 | true | bundle-post-response | rds-post-json |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Resource** | **WarningOnly** |
| * | Confirm that the response body contains a Bundle | response | Bundle | false |



> **test****name**: RDS-Queries-verification-read**description**: Read the posted Observation as a Radiation Dose Summary resource
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | Observation | Read the Observation ${rdsResourceId} | json | true | /${rdsResourceId} | rds-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |



> **teardown**
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code delete](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-delete): Delete | Observation | Relete the Observation ${rdsResourceId} | json | true | /${rdsResourceId} |


> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code delete](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-delete): Delete | ImagingStudy | Relete the ImagingStudy ${imagingStudyResourceId} | json | true | /${imagingStudyResourceId} |


> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code delete](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-delete): Delete | Patient | Relete the Patient ${patientResourceId} | json | true | /${patientResourceId} |


> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code delete](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-delete): Delete | Practitioner | Relete the Practitioner ${practitionerResourceId} | json | true | /${practitionerResourceId} |





## Resource Content

```json
{
  "resourceType" : "TestScript",
  "id" : "RDSP-Simulator",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/TestScript/RDSP-Simulator",
  "version" : "1.0.0",
  "name" : "TestScript_RDSP_Simulator",
  "status" : "active",
  "date" : "2021-07-17",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "TestScript to validate the FHIR Server capabilities against an RDSP actor.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "copyright" : "HL7 2021",
  "destination" : [
    {
      "index" : 1,
      "profile" : {
        "system" : "http://terminology.hl7.org/CodeSystem/testscript-profile-destination-types",
        "code" : "FHIR-Server",
        "display" : "FHIR Server"
      }
    }
  ],
  "fixture" : [
    {
      "id" : "rds-post-json",
      "autocreate" : false,
      "autodelete" : false,
      "resource" : {
        "reference" : "Bundle/Bundle-RDS-resources"
      }
    }
  ],
  "variable" : [
    {
      "name" : "rdsResourceId",
      "path" : "Bundle/entry/resource/Observation/id",
      "sourceId" : "bundle-post-response"
    },
    {
      "name" : "patientResourceId",
      "path" : "Bundle/entry/resource/Patient/id",
      "sourceId" : "bundle-post-response"
    },
    {
      "name" : "deviceResourceId",
      "path" : "Bundle/entry/resource/Device/id",
      "sourceId" : "bundle-post-response"
    },
    {
      "name" : "practitionerResourceId",
      "path" : "Bundle/entry/resource/Practitioner/id",
      "sourceId" : "bundle-post-response"
    },
    {
      "name" : "imagingStudyResourceId",
      "path" : "Bundle/entry/resource/ImagingStudy/id",
      "sourceId" : "bundle-post-response"
    }
  ],
  "test" : [
    {
      "name" : "RDS-Queries-verification-POST",
      "description" : "This is a Test to validate the FHIR server capabilities according to Radiation Dose Summary searching possibilities.",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "transaction"
            },
            "description" : "Submit a bundle of resources creating the radiation dose summary",
            "accept" : "json",
            "contentType" : "json",
            "destination" : 1,
            "encodeRequestUrl" : true,
            "responseId" : "bundle-post-response",
            "sourceId" : "rds-post-json"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the response body contains a Bundle",
            "direction" : "response",
            "resource" : "Bundle",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "RDS-Queries-verification-read",
      "description" : "Read the posted Observation as a Radiation Dose Summary resource",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "Observation",
            "description" : "Read the Observation ${rdsResourceId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${rdsResourceId}",
            "responseId" : "rds-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        }
      ]
    }
  ],
  "teardown" : {
    "action" : [
      {
        "operation" : {
          "type" : {
            "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
            "code" : "delete"
          },
          "resource" : "Observation",
          "description" : "Relete the Observation ${rdsResourceId}",
          "accept" : "json",
          "encodeRequestUrl" : true,
          "params" : "/${rdsResourceId}"
        }
      },
      {
        "operation" : {
          "type" : {
            "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
            "code" : "delete"
          },
          "resource" : "ImagingStudy",
          "description" : "Relete the ImagingStudy ${imagingStudyResourceId}",
          "accept" : "json",
          "encodeRequestUrl" : true,
          "params" : "/${imagingStudyResourceId}"
        }
      },
      {
        "operation" : {
          "type" : {
            "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
            "code" : "delete"
          },
          "resource" : "Patient",
          "description" : "Relete the Patient ${patientResourceId}",
          "accept" : "json",
          "encodeRequestUrl" : true,
          "params" : "/${patientResourceId}"
        }
      },
      {
        "operation" : {
          "type" : {
            "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
            "code" : "delete"
          },
          "resource" : "Practitioner",
          "description" : "Relete the Practitioner ${practitionerResourceId}",
          "accept" : "json",
          "encodeRequestUrl" : true,
          "params" : "/${practitionerResourceId}"
        }
      }
    ]
  }
}

```
