# Radiation Summary Report - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Resource Profile: Radiation Summary Report 

 
A report document describing the irradiation act 

**Usages:**

* Examples for this Profile: [Composition/1](Composition-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.uv.radiation-dose-summary|current/StructureDefinition/radiation-summary-report)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-radiation-summary-report.csv), [Excel](../StructureDefinition-radiation-summary-report.xlsx), [Schematron](../StructureDefinition-radiation-summary-report.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "radiation-summary-report",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-summary-report",
  "version" : "1.0.0",
  "name" : "RadiationSummaryReport",
  "title" : "Radiation Summary Report",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-29T17:37:08+00:00",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "A report document describing the irradiation act",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "mustSupport" : true
      },
      {
        "id" : "Composition.type.coding",
        "path" : "Composition.type.coding",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "73569-6",
          "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "short" : "Related patient",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code.coding"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.section:radiationDoseSummary",
        "path" : "Composition.section",
        "sliceName" : "radiationDoseSummary",
        "short" : "Map to the Radiation Dose Summary Observation resource",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:radiationDoseSummary.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "73569-6",
          "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
        }
      },
      {
        "id" : "Composition.section:radiationDoseSummary.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-dose-summary"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:pregnancyObservation",
        "path" : "Composition.section",
        "sliceName" : "pregnancyObservation",
        "short" : "Map to the Pregnancy Status Observation resource",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancyObservation.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "82810-3",
          "display" : "Pregnancy status"
        }
      },
      {
        "id" : "Composition.section:pregnancyObservation.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:indicationObservation",
        "path" : "Composition.section",
        "sliceName" : "indicationObservation",
        "short" : "Map to Indication Observation resource",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:indicationObservation.code.coding",
        "path" : "Composition.section.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://dicom.nema.org/resources/ontology/DCM",
          "version" : "2025.2.20250411",
          "code" : "121109",
          "display" : "Indications for Procedure"
        }
      },
      {
        "id" : "Composition.section:indicationObservation.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/indication-observation"
            ]
          }
        ]
      }
    ]
  }
}

```
