# RadiationDoseSummary-545 - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Example Observation: RadiationDoseSummary-545

Language: en

Profile: [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)

**partOf**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25; status = available; started = 2019-01-23 11:45:30+0000](ImagingStudy-344.md)

**status**: Final

**code**: Radiation exposure and protection information [Description] Document Diagnostic imaging

**subject**: [Pascale Dupont](Patient-56.md)

**focus**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25; status = available; started = 2019-01-23 11:45:30+0000](ImagingStudy-344.md)

**effective**: 2019-01-23 12:00:30+0000

**performer**: [John Moore](Practitioner-33.md)

**value**: Dose (RP) Total = 212 mGy, DAP Total = 13639 mGy.cm2, Fluoro DAP Total = 4523 mGy.cm2, Total Fluoro Time = 450s

**device**: [XA01](Device-12.md)

> **component****code**:Procedure reported**value**:Projection X-Ray

> **component****code**:Dose (RP) Total**value**: 212 mGy

> **component****code**:Dose Area Product Total**value**: 13639 mGy.cm2

> **component****code**:Total Fluoro Time**value**: 450 s



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "545",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-dose-summary"
    ]
  },
  "language" : "en",
  "partOf" : [
    {
      "reference" : "ImagingStudy/344",
      "identifier" : {
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
              "code" : "study-instance-uid",
              "display" : "Study Instance UID"
            }
          ]
        },
        "system" : "urn:dicom:uid",
        "value" : "urn:oid:1.2.840.121.3.32.0.1.25"
      }
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "73569-6",
        "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/56",
    "display" : "Pascale Dupont"
  },
  "focus" : [
    {
      "reference" : "ImagingStudy/344"
    }
  ],
  "effectiveDateTime" : "2019-01-23T12:00:30.000Z",
  "performer" : [
    {
      "reference" : "Practitioner/33",
      "display" : "John Moore"
    }
  ],
  "valueString" : "Dose (RP) Total = 212 mGy, DAP Total = 13639 mGy.cm2, Fluoro DAP Total = 4523 mGy.cm2, Total Fluoro Time = 450s",
  "device" : {
    "reference" : "Device/12",
    "display" : "XA01"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "121058",
            "display" : "Procedure reported"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113704",
            "display" : "Projection X-Ray"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113725",
            "display" : "Dose (RP) Total"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 212,
        "unit" : "mGy"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113722",
            "display" : "Dose Area Product Total"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 13639,
        "unit" : "mGy.cm2"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113730",
            "display" : "Total Fluoro Time"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 450,
        "unit" : "s"
      }
    }
  ]
}

```
