# RadiationDoseSummary-122 - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Example Observation: RadiationDoseSummary-122

Language: en

Profile: [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)

**partOf**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.32; status = available; started = 2019-01-23 11:45:30+0000](ImagingStudy-22.md)

**status**: Final

**code**: Radiation exposure and protection information [Description] Document Diagnostic imaging

**subject**: [Pascale Dupont](Patient-56.md)

**focus**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.32; status = available; started = 2019-01-23 11:45:30+0000](ImagingStudy-22.md)

**effective**: 2019-01-23 12:00:30+0000

**performer**: [John Moore](Practitioner-33.md)

**value**: Activity = 154 MBq (123-I)

> **component****code**:Procedure reported**value**:Radiopharmaceutical Administration

> **component****code**:Administered activity**value**: 154 MBq

> **component****code**:Radiopharmaceuticals**value**:Product containing ioflupane (123-I) (medicinal product)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "122",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-dose-summary"
    ]
  },
  "language" : "en",
  "partOf" : [
    {
      "reference" : "ImagingStudy/22",
      "identifier" : {
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
              "code" : "study-instance-uid",
              "display" : "Study Instance UID"
            }
          ]
        },
        "system" : "urn:dicom:uid",
        "value" : "urn:oid:1.2.840.121.3.32.0.1.32"
      }
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "73569-6",
        "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/56",
    "display" : "Pascale Dupont"
  },
  "focus" : [
    {
      "reference" : "ImagingStudy/22"
    }
  ],
  "effectiveDateTime" : "2019-01-23T12:00:30.000Z",
  "performer" : [
    {
      "reference" : "Practitioner/33",
      "display" : "John Moore"
    }
  ],
  "valueString" : "Activity = 154 MBq (123-I)",
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "121058",
            "display" : "Procedure reported"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113502",
            "display" : "Radiopharmaceutical Administration"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113507",
            "display" : "Administered activity"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 154,
        "unit" : "MBq"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "349358000",
            "display" : "Radiopharmaceuticals"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "429296007",
            "display" : "Product containing ioflupane (123-I) (medicinal product)"
          }
        ]
      }
    }
  ]
}

```
