# FHIR Server supporting FHIR operations in order to interact with RDSP Actor - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## CapabilityStatement: FHIR Server supporting FHIR operations in order to interact with RDSP Actor 

 
Defines the operations requirement for FHIR server interacting with RDSP actor 

 [Raw OpenAPI-Swagger Definition file](../FHIRServer-RDSP.openapi.json) | [Download](../FHIRServer-RDSP.openapi.json) 

## FHIR Server supporting FHIR operations in order to interact with RDSP Actor

* Implementation Guide Version: 1.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `xml`, `json`
* Published on: 2021-06-28 
* Published by: HL7 International / Imaging Integration 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary](index.md)

## FHIR RESTful Capabilities

### Mode: server

Description of the needed resources to be supported by the FHIR server, and the different possible interactions.

**Summary of System-wide Interactions**

* Supports the `transaction`interaction.
* Supports the `search-system`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Patient](#Patient1-1) |   | Y | **Y** |  | y? | identifier, given |  |  |  |
| [Practitioner](#Practitioner1-2) |   | Y | **Y** |  | y? | identifier, given |  |  |  |
| [ImagingStudy](#ImagingStudy1-3) |   | Y | **Y** |  | y? | patient |  |  |  |
| [Device](#Device1-4) |   | Y | **Y** |  | y? | manufacturer |  |  |  |
| [Observation](#Observation1-5) |   | Y | Y |  | **Y** | identifier, patient, code |  |  |  |

-------

#### Resource Conformance: SHALL Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`.
* **SHOULD** support `read`.
* **MAY** support `create`.

Documentation
> 

Search on patients needs to be available on FHIR server, and patient create can be activated based on the covered use case.


Search Parameters


 

#### Resource Conformance: SHALL Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`.
* **SHOULD** support `read`.
* **MAY** support `create`.

Search Parameters


 

#### Resource Conformance: SHALL ImagingStudy

Core FHIR Resource

[ImagingStudy](http://hl7.org/fhir/R4/imagingstudy.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`.
* **SHOULD** support `read`.
* **MAY** support `create`.

Search Parameters


 

#### Resource Conformance: SHALL Device

Core FHIR Resource

[Device](http://hl7.org/fhir/R4/device.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`.
* **SHOULD** support `read`.
* **MAY** support `create`.

Search Parameters


 

#### Resource Conformance: SHALL Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* **SHALL** support `create`.
* **SHOULD** support `read`, `search-type`.

Search Parameters


 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "FHIRServer-RDSP",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/CapabilityStatement/FHIRServer-RDSP",
  "version" : "1.0.0",
  "name" : "FHIRServer_RDSP",
  "title" : "FHIR Server supporting FHIR operations in order to interact with RDSP Actor",
  "status" : "active",
  "date" : "2021-06-28",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "Defines the operations requirement for FHIR server interacting with RDSP actor",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Description of the needed resources to be supported by the FHIR server, and the different possible interactions.",
      "resource" : [
        {
          "type" : "Patient",
          "documentation" : "Search on patients needs to be available on FHIR server, and patient create can be activated based on the covered use case.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "given",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "given",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "ImagingStudy",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Device",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "manufacturer",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Observation",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "code",
              "type" : "token"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction"
        },
        {
          "code" : "search-system"
        }
      ]
    }
  ]
}

```
