# Home - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Home

This IG standardizes the sharing of minimal radiation information following a performed exam. National and regional regulations may require minimal radiation data in imaging reports. This IG standardizes the exchange of radiation data generated by dose management systems from imaging procedures with other interconnected systems.

### Organization of this implementation guide

This IG is organized into three main sections:

* [Chapter I](background.md): Background - Introduction and overview 
* [Problem](background.md#problem) - Description of the problem
* [Scope](background.md#scope) - Scope of the IG
* [Use cases](background.md#usecases) - Key use cases covered by the IG
* [Minimal Radiation Information](background.md#mindose) - Description of data shared through this IG
* [Glossary](background.md#glossary) - Glossary
* [References](background.md#references) - References
 
* [Chapter II](archi.md): Architecture & Implementation 
* [Profiles & Extensions](archi.md#profiles) - FHIR Profiles and extensions defined in the IG
* [Actors](archi.md#actors) - Actors participating in the IG
* [Terminology](archi.md#terminology) - Value Sets defined and used
* [Security Consideration](archi.md#sec) - Security aspects to be taken in consideration
 
* [Chapter III](testing.md): Testing & Conformance 
* [Test Plan](testing.md#testplan) - Test plans for the different actors
* [Test Data](testing.md#testdata) - Test data that can be used
* [Resources Samples](testing.md#samples) - Samples of resources profiled following this IG
 

### Copyrights and acknowledgments

This document is licensed under Creative Commons "No Rights Reserved" (CC0).

#### Value Sets

Value Sets in this guide include:

* Vocabulary Content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organization (IHTSDO) and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement
* Vocabulary Content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at LOINC/license.

#### Trademarks

LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

SNOMED® and "SNOMED CT" are registered trademarks of the IHTSDO.

HL7®, HEALTH LEVEL SEVEN®, FHIR® and the FHIR® Logo are trademarks owned by Health Level Seven International, registered with the United States Patent and Trademark Office.

DICOM® is a registered trademark of the National Electrical Manufacturers Association for its standards publications relating to digital communications of medical information.

IHE® is a registered trademark of the Healthcare Information Management Systems Society in the United States and trademarks of IHE Europe in the European Community.

### Sponsors Working Groups

* [Imaging Integration Work Group](http://www.hl7.org/Special/committees/imagemgt/index.cfm)
* [Clinical Quality Information Work Group](http://www.hl7.org/Special/committees/cqi/index.cfm)

### Contributors

| | | |
| :--- | :--- | :--- |
| Abderrazek Boufahja | GE Healthcare | Author |
| Jonathan Whitby | Canon Group Company | Contributor |
| Steven Nichols | GE Healthcare | Contributor |

