# Background - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Background

This chapter describes the scope of this guide, provides background information about the radiation dose summary IG, key concepts, and describes the use cases supported by this implementation guide.

1. [Problem](#problem)- Description of the problem
1. [Scope](#scope)- Scope of the IG
1. [Use case](#usecases)- Key use case covered by the IG
1. [Minimal Radiation Information](#mindose)- Description of data shared through this IG
1. [Underlying specifications](#underlying-specs)- Description of the underlying specifications and resources.
1. [Glossary](#glossary)- Glossary of terms used in this IG
1. [References](#references)- Useful references
1. [IG Dependencies](#ig-dependencies)- Dependencies on other IGs
1. [Global Profiles](#global-profiles)- Global profiles used in this IG
1. [Copyrights](#copyrights)- Copyrights and acknowledgments
1. [Expansion Parameters](#expansion-parameters)- Expansion parameters used in ValueSets

### Problem

The IHE Dose Reporter actor within the IHE (Radiation Exposure Monitoring) REM profile gathers radiation information and dose reports from modalities. However, there is no standard to expose a dose summary to third parties in a light API based format.

![](./problem.svg)

Note: This IG also supports the summary of Radiopharmaceutical dose (not depicted above), in which Radiopharmaceutical Activity Information is provided to the Dose Info Reporter by the Radiopharmaceutical Activity Supplier. See [IHE REM for Nuclear Medicine (REM-NM)](https://ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_Suppl_REM-NM.pdf) for more information.

The Dose Reporter (a.k.a. Dose Management system) needs to share information related to exam dose to multiple systems outside the REM profile.

Radiation Dose Structured Reports (RDSRs) and Radiopharmaceutical Radiation Dose SRs (RRDSRs) have a complete and stable structure for recording dose information however, many Radiology Information (RIS) and Electronic Health Record (EHR) systems lack the capability to consume them. In most cases, the RIS/EHR need are light, requiring only a dose summary for inclusion in radiology reports, warranting a lightweight standard to obtain the necessary information from the Dose Management system.

The emergence of HL7 FHIR simplified the exchange between back end applications and other systems through the exchange of resources with stable structures. This IG facilitates the sharing of minimal dose information through FHIR Resources.

### Scope

The defined profiles in this IG describe radiation information within a unique irradiation act, which may contain multiple irradiation events. This IG does not provide sufficient information to guide patient care decisions, or to influence decision making prior to prescribing studies.

In Scope:

* Summary of dose information by exam through FHIR
* Irradiation to which the patient was exposed
* CT, XA, DX, RF, MG, NM

Out of Scope:

* Details of radiation administration
* Enhanced data (SSDE, Organ Dose, etc.)
* Cumulative calculation of radiation over time
* Irradiation to which the practitioner was exposed
* Radiotherapy

Details of radiation administration (e.g., X-ray parameters, modality configuration, etc.) and enhanced data (e.g., size specific dose estimation), are available in DICOM Radiation Structured Reports (RDSRs).

Interpretation of radiation information may be influenced by several external factors not addressed in this IG.

The FHIR profiles defined in this IG are a solution to simplify sharing the radiation summary information between applications. This IG is not meant to describe how the radiation data is assessed or who can access and interpret it. Such interpretation requires domain expertise and additional data not available in RDSRs or RRDSRs. Implementers are urged to follow international and national regulations and recommendations, such as [AAPM/ACR/HPS Joint Statement on Proper Use of Radiation Dose Metric Tracking for Patients Undergoing Medical Imaging Exams](https://www.aapm.org/org/policies/details.asp?id=1533&type=PP).

### Use case: Imaging report construction

![](./usecase1.svg)

The main use case identified for this implementation guide is the following:

* The modality transfers the dose report to the Dose Management System (i.e. IHE REM Dose Reporter).
* After analyzing the study, the radiologist dictates a report within the Radiology Information System (RIS).
* The RIS queries the Dose Management system to obtain a Dose Summary.
* The RIS incorporates the Dose Summary into to the report.
* The radiologist signs the final report.
* The report is available in the hospital EHR.
* Optionally (not shown), the report is shared with the regional/national radiology report repository.

Note: this case shows the RIS pulling (GET) the Dose Summary, it could also be pushed (PUT)

This case is common in RIS systems without a dose management module, in which gathering dose information from multiple sources can be complex due to:

* multiple sources of data (e.g., RDSR, MPPS, SC & OCR, and DICOM image metadata), and
* coercion of reported data in order to provide summary.

It is the role of the Dose Management system to provide the RIS with the correct information regarding the administered dose. Reporting the minimal dose information within the final imaging report is recommended by various organizations, and may be required by local regulation. For example:

* French order of 22 September 2006 requires the report to provide information justifying the procedure,the operations carried out, as well as the data used to estimate the dose received by the patient.
* California Senate bill Senate Bill No. 1237 requires "…health facilities and clinics that use imaging procedures that involve computed tomography X-ray systems (CT) for human use to record the dose of radiation on every CT study produced during a CT examination."

### Minimal Radiation Information

#### Identification

In this paragraph, we analyze the mapping between the identified minimal dose information and some specifications on dose information reporting coming from multiple stakeholders:

* [DICOM PS3.20: Imaging Reports using HL7 Clinical Document Architecture](http://dicom.nema.org/medical/dicom/current/output/html/part20.html)
* [DICOM PS3.16: Content Mapping Resource](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/PS3.16.html) 
* [X-Ray Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_XRayRadiationDoseSRIODTemplates.html)
* [CT Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CTRadiationDoseSRIODTemplates.html)
* [Radiopharmaceutical Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_RadiopharmaceuticalRadiationDoseSRIODTemplates.html)
* [TID 2008 - Radiation Exposure and Protection Information](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_A.html#sect_TID_2008)
 
* France guidelines 
* French Society of Radiology - SFR, [Practical Guide for Interventional Radiology](http://gri.radiologie.fr/) (Guideline - 2013)
* High Authority of Health - HAS, [Patient radiation protection and analysis of CPD practices and certification of healthcare establishments](https://www.has-sante.fr/upload/docs/application/pdf/2013-07/radioprotection_du_patient_et_analyse_des_pratiques_dpc_et_certification_des_etablissements_de_sante_format2clics.pdf) (Guideline - 2012)
* [Presentation of the main radiation protection regulatory provisions applicable in medical and dental radiology](https://www.cd2-conseils.com/wp-content/uploads/2016/11/rp_asn_presentation-principales-dispositions-reglementaires_2016.pdf) (Guideline: 2016)
* French Minister of Health and Solidarity, [Order of 22 September 2006 relating to the radiation information to be included in an act report using ionizing radiation](https://www.legifrance.gouv.fr/eli/arrete/2006/9/22/SANY0623888A/jo/texte), (Order - 2006)
 
* Finnish Imaging Report specification, [KanTa Imaging CDA R2 document structures](http://www.hl7.fi/hl7-rajapintakartta/kanta-%E2%80%93-kuvantamisen-cda-r2-rakenne/) (2013)
* US, California State 
* AAPM, [Computed Tomography Dose Limit Reporting Guidelines for Section 3 – 115113](https://aapm.org/government_affairs/documents/SB-1237Section3_v7.pdf)
* [Senate Bill No. 1237, CHAPTER 521](http://www.leginfo.ca.gov/pub/09-10/bill/sen/sb_1201-1250/sb_1237_bill_20100929_chaptered.pdf)
* AAPM, [Experience with California Law on Reporting CT Dose](http://amos3.aapm.org/abstracts/pdf/77-22649-312436-91875.pdf)
* [Radiologist Compliance With California CT Dose Reporting Requirements: A Single-Center Review of Pediatric Chest CT](https://www.ajronline.org/doi/pdf/10.2214/AJR.14.13693)
* University of California Dose Optimization and Standardization Endeavor (UC-DOSE). [Recommendations for compliance with California Senate Bill 1237 and related pending legislation.](http://files.ctctcdn.com/da9de144201/b78c37fa-a36b-4888-a418-fa21a314393e.pdf)
 

The analysis of the different specifications allowed to obtain the following coverage between the minimal dose information and these specifications/guidelines:

* **Dose measurements - Irradiation Event level**: *Dose (RP) Total*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *Accumulated Average Glandular Dose*
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Dose Area Product Total*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  : Y
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Fluoro Dose Area Product Total*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *Acquisition Dose Area Product Total*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *Total Fluoro Time*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *Total Number of Radiographic Frames*
  *  :  
  *  : Y
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *CT Dose Length Product Total*
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  : Y
  *  : Y
* **Dose measurements - Irradiation Event level**: *Administered activity*
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Radiopharmaceutical Agent*
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Radionuclide*
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Radiopharmaceutical Volume*
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
* **Dose measurements - Irradiation Event level**: *Route of administration*
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
* **Dose measurements - Irradiation Event level**: *Mean CTDIvol*
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  : Y
* **Dose measurements - Irradiation Event level**: *DLP*
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
* **Dose measurements - Irradiation Event level**: *Target Region*
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  : Y
* **Dose measurements - Irradiation Event level**: *CTDIw Phantom Type*
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  :  
  *  : Y

#### Concepts mapping

The minimal dose information that should be collected by the Dose Management system and shared with third party applications are divided into contextual data and dose measurement data.

Contextual Information data:

| | | |
| :--- | :--- | :--- |
| Irradiation Authorizing Person | [EV (113850, DCM, Irradiation Authorizing)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113850) | Procedure |
| Pregnancy Observation | [EV (82810-3, LN, Pregnancy status)](http://snomed.info/id/364320009) | Procedure |
| Indication Observation | [EV (18785-6, LN, Indications for Procedure)](http://loinc.org/18785-6/) | Procedure |
| Irradiating Device | [EV (113859, DCM, Irradiating Device)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113859) | Procedure |
| Irradiation Issued Date | [EV (113809, DCM, Start of X-Ray Irradiation)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113809) | Procedure |
| Related Imaging Study | [EV (110180, DCM, Study Instance UID)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_110180) | Procedure |

Dose measurements data:

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Dose (RP) Total | [EV (113725, DCM, Dose (RP) Total)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113725) | [TID 10007](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10007.html) | Procedure | Quantity | mGy |
| Accumulated Average Glandular Dose | [EV (111637, DCM, Accumulated Average Glandular Dose)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_111637) | [TID 10005](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10005.html) | Procedure | Quantity | mGy |
| Dose Area Product Total | [EV (113722, DCM, Dose Area Product Total)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113722) | [TID 10007](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10007.html) | Procedure | Quantity | mGy.cm2 |
| Fluoro Dose Area Product Total | [EV (113726, DCM, Fluoro Dose Area Product Total)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113726) | [TID 10004](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10004.html) | Procedure | Quantity | mGy.cm2 |
| Acquisition Dose Area Product Total | [EV (113727, DCM, Acquisition Dose Area Product Total)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113727) | [TID 10004](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10004.html) | Procedure | Quantity | mGy.cm2 |
| Total Fluoro Time | [EV (113730, DCM, Total Fluoro Time)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113730) | [TID 10004](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10004.html) | Procedure | Quantity | s |
| Total Number of Radiographic Frames | [EV (113731, DCM, Total Number of Radiographic Frames)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113731) | [TID 10007](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10007.html) | Procedure | Integer |   |
| CT Dose Length Product Total | [EV (113813, DCM, CT Dose Length Product Total)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113813) | [TID 10012](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10012.html) | Procedure | Quantity | mGy.cm |
| Administered activity | [EV (113507, DCM, Administered activity)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113507) | [TID 10022](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10022.html) | Administration | Quantity | MBq |
| Radiopharmaceutical Agent | [EV (349358000, SCT, Radiopharmaceutical agent)](http://snomed.info/id/349358000) | [TID 10022](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10022.html) | Administration | CodeableConcept | [Radiopharmaceuticals Value Set](ValueSet-radiopharmaceutical-rds-vs.md) |
| Radionuclide | [EV (89457008, SCT, Radionuclide)](http://snomed.info/id/89457008) | [TID 10022](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10022.html) | Administration | CodeableConcept | [Isotopes Value Set](ValueSet-isotope-rds-vs.md) |
| Radiopharmaceutical Volume | [EV (123005, DCM, Radiopharmaceutical Volume)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_123005) | [TID 10022](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10022.html) | Administration | Quantity | cm3 |
| Route of administration | [EV (410675002, SCT, Route of administration)](http://snomed.info/id/410675002) | [TID 10022](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10022.html) | Administration | CodeableConcept | [Route of Administration](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_11.html) |
| Mean CTDIvol | [EV (113830, DCM, Mean CTDIvol)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113830) | [TID 10013](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10013.html) | Irradiation Event | Quantity | mGy |
| DLP | [EV (113838, DCM, DLP)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113838) | [TID 10013](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10013.html) | Irradiation Event | Quantity | mGy.cm |
| Target Region | [EV (123014, DCM, Target Region)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_123014) | [TID 10013](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10013.html) | Irradiation Event | CodeableConcept | [Anatomy Imaged](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4030.html) |
| CTDIw Phantom Type | [EV (113835, DCM, CTDIw Phantom Type)](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_D.html#DCM_113835) | [TID 10013](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_TID_10013.html) | Irradiation Event | CodeableConcept | [Phantom Devices](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_4052.html) |

**Remarks**:

* We highlighted the "Dose (RP) Total" and not the "Entrance Exposure at RP", as the latter one is related to the irradiation event level, and not the procedure level. Even if the PS3.20 is referencing the Entrance Exposure at RP, the IEC 61910-1 is referencing the Dose (RP) Total in the Basic Dose Documentation conformance.
* For NM, most of the minimal dose information related to procedure are described in the irradiation event level of the RRDSR structure. However, as there is only one irradiation event per RRDSR, we considered that this minimal dose information is related to the procedure level. However, this implies that for the same NM imaging procedure, multiple Radiation Dose Summaries can be reported. This should not be a problem, as in this case the radiation dose summary is related to the administration act, more than the procedure act.
* The irradiation Issued Date has different significations, based on the targeted procedure type; in CT, it is the start date of the irradiation act, in XA/RF/MG, it is the Series Date Time, and in NM, it is the administration date time.
* The associated procedure is referenced through the related Imaging Study.
* The calibration factors are not reported as part of the minimal dose information. The generator of the Dose Summary resources shall take in consideration these calibration factors.
* Based on the analyzes performed, there is no minimal dose information related to the level Irradiation Event and part of the modalities XA/RF/MG.

### Underlying specifications

This IG is based on [HL7 FHIR](http://hl7.org/fhir/R4/index.html) standard, as well as [DICOM](https://www.dicomstandard.org/current) standard, and its packaged value sets [fhir.dicom](http://fhir.org/packages/fhir.dicom). This IG uses also a profile from the specification [International Patient Summary IG (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/). Implementers of this specification must understand some basic information about the underlying specifications listed above.

#### FHIR

This IG uses terminology, notations and design principles that are specific to the HL7 FHIR standard. Before reading the page [architecture and implementation](archi.md), it is important to be familiar with the basic principles of FHIR and how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to review the following prior to reading the rest of this implementation guide.

* [FHIR overview](http://hl7.org/fhir/R4/overview.html)
* [Developer's introduction](http://hl7.org/fhir/R4/overview-dev.html) (or [Clinical introduction](http://hl7.org/fhir/R4/overview-clinical.html))
* [FHIR data types](http://hl7.org/fhir/R4/datatypes.html)
* [Using codes](http://hl7.org/fhir/R4/terminologies.html)
* [References between resources](http://hl7.org/fhir/R4/references.html)
* [How to read resource & profile definitions](http://hl7.org/fhir/R4/formats.html)
* [Base resource](http://hl7.org/fhir/R4/resource.html)

This implementation guide supports the recently published [FHIR R4](http://hl7.org/fhir/R4/index.html) version of the FHIR standard to ensure alignment with the current direction of the FHIR standard.

#### FHIR resources used

The table below identifies the specific FHIR Resources and their purposes that will be used in this IG. Implementers should familiarize themselves with these FHIR resources and their purposes.

| | |
| :--- | :--- |
| [Observation](http://hl7.org/fhir/R4/observation.html) | Used to describe the radiation dose summary and the collected minimal dose information |
| [Patient](http://hl7.org/fhir/R4/patient.html) | Used to reference the irradiated person |
| [Practitioner](http://hl7.org/fhir/R4/practitioner.html) | Used to reference the related irradiation authorizing person |
| [Device](http://hl7.org/fhir/R4/device.html) | Used to describe the irradiating modality |
| [ImagingStudy](http://hl7.org/fhir/R4/imagingstudy.html) | Used to reference the performed exam |
| [Composition](http://hl7.org/fhir/R4/composition.html) | Used to create the irradiation report |

#### DICOM® Standard

DICOM® is used as reference standard, as it provides a complete definition of the dose information that can be present in a radiation report. The DICOM® version used in this IG is the [2021d](https://dicom.nema.org/medical/dicom/2021d/output/) release. The packaged value sets coming from DICOM within [fhir.dicom](http://fhir.org/packages/fhir.dicom) are referenced many times in the different profiles of this IG.

[DICOM®](https://www.dicomstandard.org/current)

#### International Patient Summary IG (IPS)

Pregnancy Status Profile from [International Patient Summary IG (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/) is used within this IG in order to report a possible pregnancy of an irradiated person.

[International Patient Summary IG (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/)

### Glossary

The following terms and acronyms are used within the Radiation Dose Summary IG:

| | |
| :--- | :--- |
| AAPM | American Association of Physicists in Medicine |
| ACR | American College of Radiology |
| ATNA | Audit Trail and Node Authentication |
| CDA | Clinical Document Architecture |
| CDS | Clinical Decision Support |
| CT | Computed Tomography |
| CTDI | Computed Tomography Dose Index |
| DAP | Dose Area Product |
| DICOM | Digital Imaging and Communications in Medicine |
| DLP | Dose Length Product |
| EHR | Electronic Health Record |
| EMR | Electronic Medical Record |
| FHIR | Fast Healthcare Interoperability Resources |
| HAS | French High Authority of Health |
| HL7 | Health Level Seven |
| HPS | Health Physics Society |
| IEC | International Electrotechnical Commission |
| IG | Implementation Guide |
| IHE | Integrating the Healthcare Enterprise |
| IOD | Information Object Definition |
| IPS | International Patient Summary |
| MG | Mammography |
| MPPS | Modality Performed Procedure Step |
| NM | Nuclear Medicine |
| OCR | Optical Character Recognition |
| PHI | Personal Health Information |
| RDSC | Radiation Dose Summary Consumer |
| RDSP | Radiation Dose Summary Producer |
| RDSR | Radiation Dose Structured Report |
| REM | Radiation Exposure Monitoring |
| REM-NM | Radiation Exposure Monitoring for Nuclear Medicine |
| REST | Representational State Transfer |
| RF | Radio Fluoroscopy |
| RIS | Radiology Information System |
| RP | Reference Point |
| RRDSR | Radiopharmaceutical Radiation Dose Structured Report |
| SFR | French Society of Radiology |
| SR | Structured Report |
| SSDE | Size Specific Dose Estimation |
| TID | Template ID |
| TLS | Transport Layer Security |
| UID | Unique identifier |
| URL | Uniform Resource Locator |
| URN | Uniform Resource Name |
| VR | Value Representation |
| XA | X-Ray Angiography |
| XDS-I.b | Cross-enterprise Document Sharing for Imaging |

### References

1. DICOM,[DICOM PS3.20: Imaging Reports using HL7 Clinical Document Architecture](http://dicom.nema.org/medical/dicom/current/output/html/part20.html)
1. DICOM,[DICOM PS3.16: Content Mapping Resource](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/PS3.16.html)
1. DICOM,[X-Ray Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_XRayRadiationDoseSRIODTemplates.html)
1. DICOM,[CT Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CTRadiationDoseSRIODTemplates.html)
1. DICOM,[Radiopharmaceutical Radiation Dose SR IOD Templates](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_RadiopharmaceuticalRadiationDoseSRIODTemplates.html)
1. DICOM,[TID 2008. Radiation Exposure and Protection Information](http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_A.html#sect_TID_2008)
1. French Society of Radiology - SFR,[Practical Guide for Interventional Radiology](http://gri.radiologie.fr/)(Guideline - 2013)
1. French High Authority of Health - HAS,[Patient radiation protection and analysis of CPD practices and certification of healthcare establishments](https://www.has-sante.fr/upload/docs/application/pdf/2013-07/radioprotection_du_patient_et_analyse_des_pratiques_dpc_et_certification_des_etablissements_de_sante_format2clics.pdf)(Guideline - 2012)
1. French nuclear safety authority,[Presentation of the main radiation protection regulatory provisions applicable in medical and dental radiology](https://www.cd2-conseils.com/wp-content/uploads/2016/11/rp_asn_presentation-principales-dispositions-reglementaires_2016.pdf)(Guideline: 2016)
1. French Minister of Health and Solidarity,[Order of 22 September 2006 relating to the radiation information to be included in an act report using ionizing radiation](https://www.legifrance.gouv.fr/eli/arrete/2006/9/22/SANY0623888A/jo/texte), (Order - 2006)
1. Finnish Imaging Report specification,[KanTa Imaging CDA R2 document structures](http://www.hl7.fi/hl7-rajapintakartta/kanta-%E2%80%93-kuvantamisen-cda-r2-rakenne/)(2013)
1. Finnish Radiation and Nuclear Safety Authority,[Röntgentutkimuksesta potilaalle aiheutuvan säteilyaltistuksen määrittäminen](https://www.julkari.fi/bitstream/handle/10024/125145/rontgensateily.pdf)(X-ray examination of the patient radiation exposure determination)
1. AAPM,[Computed Tomography Dose Limit Reporting Guidelines for Section 3 – 115113](https://aapm.org/government_affairs/documents/SB-1237Section3_v7.pdf)
1. [Senate Bill No. 1237, CHAPTER 521](http://www.leginfo.ca.gov/pub/09-10/bill/sen/sb_1201-1250/sb_1237_bill_20100929_chaptered.pdf)
1. AAPM,[Experience with California Law on Reporting CT Dose](http://amos3.aapm.org/abstracts/pdf/77-22649-312436-91875.pdf)
1. [Radiologist Compliance With California CT Dose Reporting Requirements: A Single-Center Review of Pediatric Chest CT](https://www.ajronline.org/doi/pdf/10.2214/AJR.14.13693)
1. University of California Dose Optimization and Standardization Endeavor (UC-DOSE).[Recommendations for compliance with California Senate Bill 1237 and related pending legislation](http://files.ctctcdn.com/da9de144201/b78c37fa-a36b-4888-a418-fa21a314393e.pdf)
1. IEC,[IEC 61910-1:2014 - Medical electrical equipment - Radiation dose documentation - Part 1: Radiation dose structured reports for radiography and radioscopy](https://webstore.iec.ch/publication/6091)
1. IHE Radiology (RAD),[Technical Framework Volume 1, Cross-enterprise Document Sharing for Imaging (XDS-I.b)](https://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Vol1.pdf)
1. IHE Radiology (RAD),[Technical Framework Volume 1, Radiation Exposure Monitoring (REM)](https://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Vol1.pdf)
1. HL7 International,[International Patient Summary Implementation Guide (IPS)](https://hl7.org/fhir/uv/ips/STU1.1/)
1. AAPM/ACR/HPS,[AAPM/ACR/HPS Joint Statement on Proper Use of Radiation Dose Metric Tracking for Patients Undergoing Medical Imaging Exams](https://www.aapm.org/org/policies/details.asp?id=1533&type=PP)

### IG Dependencies

This IG Contains the following dependencies on other IGs.

### Global Profiles

*There are no Global profiles defined*

### Copyrights

This publication includes IP covered under the following statements.

* These codes are derived from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 6: Data Dictionary, Copyright © 2025 by the National Electrical Manufacturers Association.

* [DICOM Identifier Type](CodeSystem-dicom-identifier-type.md): [Bundle/Bundle-RDS-resources](Bundle-Bundle-RDS-resources.md), [Device/12](Device-12.md)...Show 6 more,[Device/539](Device-539.md),[ModalityDevice](StructureDefinition-modality-device.md),[Observation/122](Observation-122.md),[Observation/139](Observation-139.md),[Observation/545](Observation-545.md)and[RadiationDoseSummary](StructureDefinition-radiation-dose-summary.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://dicom.nema.org/resources/ontology/DCM): [Bundle/Bundle-RDS-resources](Bundle-Bundle-RDS-resources.md), [ComponentRadiationDoseSummaryVS](ValueSet-component-radiation-dose-summary-vs.md)...Show 12 more,[Composition/1](Composition-1.md),[Device/12](Device-12.md),[Device/539](Device-539.md),[IndicationObservation](StructureDefinition-indication-observation.md),[ModalityDevice](StructureDefinition-modality-device.md),[Observation/122](Observation-122.md),[Observation/139](Observation-139.md),[Observation/33](Observation-33.md),[Observation/545](Observation-545.md),[ProcedureReportedTypeVS](ValueSet-procedure-reported-type-rds-vs.md),[RadiationDoseSummary](StructureDefinition-radiation-dose-summary.md)and[RadiationSummaryReport](StructureDefinition-radiation-summary-report.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/Bundle-RDS-resources](Bundle-Bundle-RDS-resources.md), [Composition/1](Composition-1.md)...Show 6 more,[Observation/122](Observation-122.md),[Observation/139](Observation-139.md),[Observation/34](Observation-34.md),[Observation/545](Observation-545.md),[RadiationDoseSummary](StructureDefinition-radiation-dose-summary.md)and[RadiationSummaryReport](StructureDefinition-radiation-summary-report.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [ComponentRadiationDoseSummaryVS](ValueSet-component-radiation-dose-summary-vs.md), [Observation/122](Observation-122.md), [Observation/139](Observation-139.md), [ProcedureReportedTypeVS](ValueSet-procedure-reported-type-rds-vs.md) and [RadiationDoseSummary](StructureDefinition-radiation-dose-summary.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Test script operation code](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html): [TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md), [TestScript_RDSP_Simulator](TestScript-RDSP-Simulator.md) and [TestScript_RDS_Sharing_Verification](TestScript-RDS-sharing-verification.md)
* [Test script profile destination type](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-profile-destination-types.html): [TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md), [TestScript_RDSP_Simulator](TestScript-RDSP-Simulator.md) and [TestScript_RDS_Sharing_Verification](TestScript-RDS-sharing-verification.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Bundle/Bundle-RDS-resources](Bundle-Bundle-RDS-resources.md), [ModalityDevice](StructureDefinition-modality-device.md) and [RadiationDoseSummary](StructureDefinition-radiation-dose-summary.md)


### Expansion Parameters

