# TestScript_RDSC_Simulator - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## TestScript: TestScript_RDSC_Simulator 

 
TestScript to validate the FHIR Server searching capabilities. 

**StructureDefinition Work Group**: ii

**url**: [TestScript TestScript_RDSC_Simulator](TestScript-RDSC-Simulator.md)

**version**: 1.0.0

**name**: TestScript_RDSC_Simulator

**status**: Active

**date**: 2021-07-17

**publisher**: HL7 International / Imaging Integration

**contact**: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), HL7 Imaging Integration Workgroup: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), Abderrazek Boufahja: [abderrazek.boufahja@gehealthcare.com](mailto:abderrazek.boufahja@gehealthcare.com)

**description**: 

TestScript to validate the FHIR Server searching capabilities.

**jurisdiction**: Global (Whole world)

**copyright**: 

HL7 2021

### Destinations

| | | |
| :--- | :--- | :--- |
| - | **Index** | **Profile** |
| * | 1 | [Test script profile destination type FHIR-Server](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-profile-destination-types.html#testscript-profile-destination-types-FHIR-Server): FHIR Server |

> **variable****name**: rdsResourceId**defaultValue**: 2535717**description**: Enter the resource ID of the Observation describing a Radiation Dose Summary, registered in your server.

> **variable****name**: patientId**expression**: Observation.subject.reference.replaceMatches('.*Patient/','').replaceMatches('/_history.*','')**sourceId**: rds-read-response

> **variable****name**: deviceId**expression**: Observation.device.reference.replaceMatches('.*Device/','').replaceMatches('/_history.*','')**sourceId**: rds-read-response

> **variable****name**: practitionerId**expression**: Observation.performer.reference.replaceMatches('.*Practitioner/','').replaceMatches('/_history.*','')**sourceId**: rds-read-response

> **variable****name**: imagingStudyId**expression**: Observation.partOf.reference.replaceMatches('.*(MedicationAdministration|MedicationDispense|MedicationStatement|Procedure|Immunization|ImagingStudy)/','').replaceMatches('/_history.*','')**sourceId**: rds-read-response

> **variable****name**: date**path**: Observation/effectiveDateTime/@value**sourceId**: rds-read-response

> **variable****name**: identifier**path**: Observation/identifier/value**sourceId**: rds-read-response

> **test****name**: Observation_read**description**: Read provided Observation - the radiation dose summary
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | Observation | Read the Radiation Dose Summary observation ${rdsResourceId} | json | true | /${rdsResourceId} | rds-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **Path** | **WarningOnly** |
| * | Confirm that the returned Observation is not empty. | response | notEmpty | Observation/id | false |



> **test****name**: Observation_search_patient**description**: Search radiation dose summary by patient
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search Radiation Dose Summary using the patientId ${patientId} | json | true | ?code=73569-6&patient=${patientId} |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: Observation_search_device**description**: Search radiation dose summary by device
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search Radiation Dose Summary using the deviceId ${deviceId} | json | true | ?code=73569-6&device=${deviceId} |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: Observation_search_partof**description**: Search radiation dose summary by part-of
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search Radiation Dose Summary using the ImagingStudy ID ${imagingStudyId} | json | true | ?code=73569-6&part-of=${imagingStudyId} |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: Observation_search_identifier**description**: Search radiation dose summary by identifier
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search Radiation Dose Summary using the identifier of the Observation ${identifier} | json | true | ?code=73569-6&identifier=${identifier} |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: Observation_search_date**description**: Search radiation dose summary by date
> **action**

### Operations

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search Radiation Dose Summary using the date of the Observation ${date} | json | true | ?code=73569-6&date=${date} |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: Observation_read_patient**description**: Read patient resource
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | Patient | Read the Patient ${patientId} | json | true | /${patientId} | patient-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **Path** | **WarningOnly** |
| * | Confirm that the returned Patient is not empty. | response | notEmpty | id | false |



> **test****name**: Observation_read_device**description**: Read device resource
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | Device | Read the Device ${deviceId} | json | true | /${deviceId} | device-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **Path** | **WarningOnly** |
| * | Confirm that the returned Device is not empty. | response | notEmpty | id | false |



> **test****name**: Observation_read_practitioner**description**: Read practitioner resource
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | Practitioner | Read the Practitioner ${practitionerId} | json | true | /${practitionerId} | practitioner-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **Path** | **WarningOnly** |
| * | Confirm that the returned Practitioner is not empty. | response | notEmpty | id | false |



> **test****name**: Observation_read_imagingstudy**description**: Read imagingstudy resource
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code read](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-read): Read | ImagingStudy | Read the ImagingStudy ${imagingStudyId} | json | true | /${imagingStudyId} | imagingstudy-read-response |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **ResponseCode** | **WarningOnly** |
| * | Confirm that the returned HTTP status is 200(OK) or 201(Created). | response | in | 200,201 | false |


> **action**

### Asserts

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Description** | **Direction** | **Operator** | **Path** | **WarningOnly** |
| * | Confirm that the returned ImagingStudy is not empty. | response | notEmpty | id | false |





## Resource Content

```json
{
  "resourceType" : "TestScript",
  "id" : "RDSC-Simulator",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/TestScript/RDSC-Simulator",
  "version" : "1.0.0",
  "name" : "TestScript_RDSC_Simulator",
  "status" : "active",
  "date" : "2021-07-17",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "TestScript to validate the FHIR Server searching capabilities.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "copyright" : "HL7 2021",
  "destination" : [
    {
      "index" : 1,
      "profile" : {
        "system" : "http://terminology.hl7.org/CodeSystem/testscript-profile-destination-types",
        "code" : "FHIR-Server",
        "display" : "FHIR Server"
      }
    }
  ],
  "variable" : [
    {
      "name" : "rdsResourceId",
      "defaultValue" : "2535717",
      "description" : "Enter the resource ID of the Observation describing a Radiation Dose Summary, registered in your server."
    },
    {
      "name" : "patientId",
      "expression" : "Observation.subject.reference.replaceMatches('.*Patient/','').replaceMatches('/_history.*','')",
      "sourceId" : "rds-read-response"
    },
    {
      "name" : "deviceId",
      "expression" : "Observation.device.reference.replaceMatches('.*Device/','').replaceMatches('/_history.*','')",
      "sourceId" : "rds-read-response"
    },
    {
      "name" : "practitionerId",
      "expression" : "Observation.performer.reference.replaceMatches('.*Practitioner/','').replaceMatches('/_history.*','')",
      "sourceId" : "rds-read-response"
    },
    {
      "name" : "imagingStudyId",
      "expression" : "Observation.partOf.reference.replaceMatches('.*(MedicationAdministration|MedicationDispense|MedicationStatement|Procedure|Immunization|ImagingStudy)/','').replaceMatches('/_history.*','')",
      "sourceId" : "rds-read-response"
    },
    {
      "name" : "date",
      "path" : "Observation/effectiveDateTime/@value",
      "sourceId" : "rds-read-response"
    },
    {
      "name" : "identifier",
      "path" : "Observation/identifier/value",
      "sourceId" : "rds-read-response"
    }
  ],
  "test" : [
    {
      "name" : "Observation_read",
      "description" : "Read provided Observation - the radiation dose summary",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "Observation",
            "description" : "Read the Radiation Dose Summary observation ${rdsResourceId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${rdsResourceId}",
            "responseId" : "rds-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned Observation is not empty.",
            "direction" : "response",
            "operator" : "notEmpty",
            "path" : "Observation/id",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_search_patient",
      "description" : "Search radiation dose summary by patient",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search Radiation Dose Summary using the patientId ${patientId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&patient=${patientId}"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_search_device",
      "description" : "Search radiation dose summary by device",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search Radiation Dose Summary using the deviceId ${deviceId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&device=${deviceId}"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_search_partof",
      "description" : "Search radiation dose summary by part-of",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search Radiation Dose Summary using the ImagingStudy ID ${imagingStudyId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&part-of=${imagingStudyId}"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_search_identifier",
      "description" : "Search radiation dose summary by identifier",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search Radiation Dose Summary using the identifier of the Observation ${identifier}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&identifier=${identifier}"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_search_date",
      "description" : "Search radiation dose summary by date",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search Radiation Dose Summary using the date of the Observation ${date}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&date=${date}"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_read_patient",
      "description" : "Read patient resource",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "Patient",
            "description" : "Read the Patient ${patientId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${patientId}",
            "responseId" : "patient-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned Patient is not empty.",
            "direction" : "response",
            "operator" : "notEmpty",
            "path" : "id",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_read_device",
      "description" : "Read device resource",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "Device",
            "description" : "Read the Device ${deviceId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${deviceId}",
            "responseId" : "device-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned Device is not empty.",
            "direction" : "response",
            "operator" : "notEmpty",
            "path" : "id",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_read_practitioner",
      "description" : "Read practitioner resource",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "Practitioner",
            "description" : "Read the Practitioner ${practitionerId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${practitionerId}",
            "responseId" : "practitioner-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned Practitioner is not empty.",
            "direction" : "response",
            "operator" : "notEmpty",
            "path" : "id",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "Observation_read_imagingstudy",
      "description" : "Read imagingstudy resource",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "read"
            },
            "resource" : "ImagingStudy",
            "description" : "Read the ImagingStudy ${imagingStudyId}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "/${imagingStudyId}",
            "responseId" : "imagingstudy-read-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned HTTP status is 200(OK) or 201(Created).",
            "direction" : "response",
            "operator" : "in",
            "responseCode" : "200,201",
            "warningOnly" : false
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the returned ImagingStudy is not empty.",
            "direction" : "response",
            "operator" : "notEmpty",
            "path" : "id",
            "warningOnly" : false
          }
        }
      ]
    }
  ]
}

```
