# TestScript_RDS_Sharing_Verification - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## TestScript: TestScript_RDS_Sharing_Verification 

 
TestScript to validate the sharing data between RDSP actor and a FHIR Server. 

**StructureDefinition Work Group**: ii

**url**: [TestScript TestScript_RDS_Sharing_Verification](TestScript-RDS-sharing-verification.md)

**version**: 1.0.0

**name**: TestScript_RDS_Sharing_Verification

**status**: Active

**date**: 2021-07-17

**publisher**: HL7 International / Imaging Integration

**contact**: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), HL7 Imaging Integration Workgroup: [http://www.hl7.org/Special/committees/imagemgt](http://www.hl7.org/Special/committees/imagemgt), Abderrazek Boufahja: [abderrazek.boufahja@gehealthcare.com](mailto:abderrazek.boufahja@gehealthcare.com)

**description**: 

TestScript to validate the sharing data between RDSP actor and a FHIR Server.

**jurisdiction**: Global (Whole world)

**copyright**: 

HL7 2021

### Destinations

| | | |
| :--- | :--- | :--- |
| - | **Index** | **Profile** |
| * | 1 | [Test script profile destination type FHIR-Server](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-profile-destination-types.html#testscript-profile-destination-types-FHIR-Server): FHIR Server |

> **variable****name**: patientIdentifier**defaultValue**: PAT3421**description**: Enter the patient identifier as used in the RDSR: tag(0010,0020) Patient ID

> **variable****name**: deviceIdentifier**defaultValue**: 767ER**description**: Enter the Device identifier as used in the RDSR: tag(0018,1000) Device Serial Number

> **variable****name**: practitionerFamily**defaultValue**: Moore**description**: Enter the Practitioner family name as used in the RDSR: TID 1020(Person Participant).EV (113871, DCM, Person ID)

> **variable****name**: practitionerGiven**defaultValue**: John**description**: Enter the Practitioner given name as used in the RDSR: TID 1020(Person Participant).EV (113871, DCM, Person ID)

> **variable****name**: studyInstanceUID**defaultValue**: 1.2.840.121.3.32.0.1.25**description**: Enter the Study Instance UID identifying the image study: tag(0020,000D) Study Instance UID

> **variable****name**: patientResourceId**path**: Bundle/entry/resource/Patient/id**sourceId**: patient-search-response

> **variable****name**: deviceResourceId**path**: Bundle/entry/resource/Device/id**sourceId**: device-search-response

> **variable****name**: practitionerResourceId**path**: Bundle/entry/resource/Practitioner/id**sourceId**: practitioner-search-response

> **variable****name**: imagingStudyResourceId**path**: Bundle/entry/resource/ImagingStudy/id**sourceId**: imagingstudy-search-response

> **test****name**: RDS_Sharing_Verification**description**: This is a test to validate the sharing of data between RDSP actor and a FHIR Server. The RDSP actor gathers an RDSR from an irradiating modality (a CT RDSR, an X-Ray RDSR or an RRDSR). Once Data collected, the RDSP will collect the right IDs for the patient, practitioner, ImagingStudy and Device from the FHIR Server, then it will generate the radiation summary resources and share them with the FHIR Server. You can refer to the complete description under : http://hl7.org/fhir/uv/radiation-dose-summary/testing.html#scenario-1-rdsr-summary-to-fhir. This test is executed after this workflow is performed, and the scripts will check the data are well received by the FHIR Server.
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Patient | Search for matching Patient related to the identifier ${patientIdentifier} | json | true | ?identifier=${patientIdentifier} | patient-search-response |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: search_device**description**: Search by device identifier
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Device | Search for matching Device related to the identifier ${deviceIdentifier} | json | true | ?identifier=${deviceIdentifier} | device-search-response |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: search_practitioner**description**: Search by practitioner name
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Practitioner | Search for matching Practitioner related to the family name ${practitionerFamily} and the given name ${practitionerGiven} | json | true | ?family=${practitionerFamily}&given=${practitionerGiven} | practitioner-search-response |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: search_ImagingStudy**description**: Search by ImagingStudy identifier
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | ImagingStudy | Search for matching ImagingStudy related to the studyInstanceUID ${studyInstanceUID} | json | true | ?identifier=urn:oid:${studyInstanceUID} | imagingstudy-search-response |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |



> **test****name**: search_rds**description**: Search Radiation Dose Summary resource by patient, device and part-of parameters
> **action**

### Operations

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Type** | **Resource** | **Description** | **Accept** | **EncodeRequestUrl** | **Params** | **ResponseId** |
| * | [Test script operation code search](http://terminology.hl7.org/6.5.0/CodeSystem-testscript-operation-codes.html#testscript-operation-codes-search): Search | Observation | Search for matching Radiation Dose Summary related to the described parameters | json | true | ?code=73569-6&device=${deviceResourceId}&patient=${patientResourceId}&part-of=${imagingStudyResourceId} | rds-search-response |


> **action**

### Asserts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Description** | **Expression** | **WarningOnly** |
| * | Confirm that the total number of response is greater than 1. | Bundle.total.toInteger() >= 1 | false |





## Resource Content

```json
{
  "resourceType" : "TestScript",
  "id" : "RDS-sharing-verification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/TestScript/RDS-sharing-verification",
  "version" : "1.0.0",
  "name" : "TestScript_RDS_Sharing_Verification",
  "status" : "active",
  "date" : "2021-07-17",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "TestScript to validate the sharing data between RDSP actor and a FHIR Server.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "copyright" : "HL7 2021",
  "destination" : [
    {
      "index" : 1,
      "profile" : {
        "system" : "http://terminology.hl7.org/CodeSystem/testscript-profile-destination-types",
        "code" : "FHIR-Server",
        "display" : "FHIR Server"
      }
    }
  ],
  "variable" : [
    {
      "name" : "patientIdentifier",
      "defaultValue" : "PAT3421",
      "description" : "Enter the patient identifier as used in the RDSR: tag(0010,0020) Patient ID"
    },
    {
      "name" : "deviceIdentifier",
      "defaultValue" : "767ER",
      "description" : "Enter the Device identifier as used in the RDSR: tag(0018,1000) Device Serial Number"
    },
    {
      "name" : "practitionerFamily",
      "defaultValue" : "Moore",
      "description" : "Enter the Practitioner family name as used in the RDSR: TID 1020(Person Participant).EV (113871, DCM, Person ID)"
    },
    {
      "name" : "practitionerGiven",
      "defaultValue" : "John",
      "description" : "Enter the Practitioner given name as used in the RDSR: TID 1020(Person Participant).EV (113871, DCM, Person ID)"
    },
    {
      "name" : "studyInstanceUID",
      "defaultValue" : "1.2.840.121.3.32.0.1.25",
      "description" : "Enter the Study Instance UID identifying the image study: tag(0020,000D) Study Instance UID"
    },
    {
      "name" : "patientResourceId",
      "path" : "Bundle/entry/resource/Patient/id",
      "sourceId" : "patient-search-response"
    },
    {
      "name" : "deviceResourceId",
      "path" : "Bundle/entry/resource/Device/id",
      "sourceId" : "device-search-response"
    },
    {
      "name" : "practitionerResourceId",
      "path" : "Bundle/entry/resource/Practitioner/id",
      "sourceId" : "practitioner-search-response"
    },
    {
      "name" : "imagingStudyResourceId",
      "path" : "Bundle/entry/resource/ImagingStudy/id",
      "sourceId" : "imagingstudy-search-response"
    }
  ],
  "test" : [
    {
      "name" : "RDS_Sharing_Verification",
      "description" : "This is a test to validate the sharing of data between RDSP actor and a FHIR Server. The RDSP actor gathers an RDSR from an irradiating modality (a CT RDSR, an X-Ray RDSR or an RRDSR). Once Data collected, the RDSP will collect the right IDs for the patient, practitioner, ImagingStudy and Device from the FHIR Server, then it will generate the radiation summary resources and share them with the FHIR Server. You can refer to the complete description under : http://hl7.org/fhir/uv/radiation-dose-summary/testing.html#scenario-1-rdsr-summary-to-fhir. This test is executed after this workflow is performed, and the scripts will check the data are well received by the FHIR Server.",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Patient",
            "description" : "Search for matching Patient related to the identifier ${patientIdentifier}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?identifier=${patientIdentifier}",
            "responseId" : "patient-search-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "search_device",
      "description" : "Search by device identifier",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Device",
            "description" : "Search for matching Device related to the identifier ${deviceIdentifier}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?identifier=${deviceIdentifier}",
            "responseId" : "device-search-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "search_practitioner",
      "description" : "Search by practitioner name",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Practitioner",
            "description" : "Search for matching Practitioner related to the family name ${practitionerFamily} and the given name ${practitionerGiven}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?family=${practitionerFamily}&given=${practitionerGiven}",
            "responseId" : "practitioner-search-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "search_ImagingStudy",
      "description" : "Search by ImagingStudy identifier",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "ImagingStudy",
            "description" : "Search for matching ImagingStudy related to the studyInstanceUID ${studyInstanceUID}",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?identifier=urn:oid:${studyInstanceUID}",
            "responseId" : "imagingstudy-search-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    },
    {
      "name" : "search_rds",
      "description" : "Search Radiation Dose Summary resource by patient, device and part-of parameters",
      "action" : [
        {
          "operation" : {
            "type" : {
              "system" : "http://terminology.hl7.org/CodeSystem/testscript-operation-codes",
              "code" : "search"
            },
            "resource" : "Observation",
            "description" : "Search for matching Radiation Dose Summary related to the described parameters",
            "accept" : "json",
            "encodeRequestUrl" : true,
            "params" : "?code=73569-6&device=${deviceResourceId}&patient=${patientResourceId}&part-of=${imagingStudyResourceId}",
            "responseId" : "rds-search-response"
          }
        },
        {
          "assert" : {
            "description" : "Confirm that the total number of response is greater than 1.",
            "expression" : "Bundle.total.toInteger() >= 1",
            "warningOnly" : false
          }
        }
      ]
    }
  ]
}

```
