# RadiationDoseSummary-139 - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Example Observation: RadiationDoseSummary-139

Language: en

Profile: [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)

**identifier**: SOP Instance UID/urn:oid:1.2.840.121.3.32.0.1.1323423.122

**partOf**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.1323423; status = available; started = 2015-01-01 22:20:00+0000](ImagingStudy-342.md)

**status**: Final

**code**: Radiation exposure and protection information [Description] Document Diagnostic imaging

**subject**: [Pascale Dupont](Patient-56.md)

**focus**: [ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.1323423; status = available; started = 2015-01-01 22:20:00+0000](ImagingStudy-342.md)

**effective**: 2015-01-01 22:23:30+0000

**performer**: [John Moore](Practitioner-33.md)

**value**: CT Dose Length Product Total = 203.12 mGy.cm

**device**: [CT01](Device-539.md)

> **component****code**:Procedure reported**value**:Computerized tomography

> **component****code**:CT Dose Length Product Total**value**: 203.12 mGy.cm



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "139",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-dose-summary"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
            "code" : "sop-instance-uid",
            "display" : "SOP Instance UID"
          }
        ]
      },
      "system" : "urn:dicom:uid",
      "value" : "urn:oid:1.2.840.121.3.32.0.1.1323423.122"
    }
  ],
  "partOf" : [
    {
      "reference" : "ImagingStudy/342",
      "identifier" : {
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
              "code" : "study-instance-uid",
              "display" : "Study Instance UID"
            }
          ]
        },
        "system" : "urn:dicom:uid",
        "value" : "urn:oid:1.2.840.121.3.32.0.1.1323423"
      }
    }
  ],
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "73569-6",
        "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/56",
    "display" : "Pascale Dupont"
  },
  "focus" : [
    {
      "reference" : "ImagingStudy/342"
    }
  ],
  "effectiveDateTime" : "2015-01-01T22:23:30.000Z",
  "performer" : [
    {
      "reference" : "Practitioner/33",
      "display" : "John Moore"
    }
  ],
  "valueString" : "CT Dose Length Product Total = 203.12 mGy.cm",
  "device" : {
    "reference" : "Device/539",
    "display" : "CT01"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "121058",
            "display" : "Procedure reported"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "77477000",
            "display" : "Computerized tomography"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://dicom.nema.org/resources/ontology/DCM",
            "version" : "2025.2.20250411",
            "code" : "113813",
            "display" : "CT Dose Length Product Total"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 203.12,
        "unit" : "mGy.cm"
      }
    }
  ]
}

```
