# DICOM Identifier Type - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## CodeSystem: DICOM Identifier Type 

 
Identifier types related to DICOM UIDs 

This Code system is referenced in the definition of the following value sets:

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "dicom-identifier-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
  "version" : "1.0.0",
  "name" : "DicomIdentifierType",
  "title" : "DICOM Identifier Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-29T17:37:08+00:00",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "Identifier types related to DICOM UIDs",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "copyright" : "These codes are derived from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 6: Data Dictionary, Copyright &#xA9; 2025 by the National Electrical Manufacturers Association.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "irradiation-event-uid",
      "display" : "Irradiation Event UID",
      "definition" : "Unique identification of the irradiation event"
    },
    {
      "code" : "device-serial-number",
      "display" : "Device Serial Number",
      "definition" : "Manufacturer's serial number of the device"
    },
    {
      "code" : "application-entity",
      "display" : "Application Entity",
      "definition" : "Title of a DICOM Application Entity"
    },
    {
      "code" : "device-uid",
      "display" : "Device UID",
      "definition" : "Unique identifier of the equipment that produced the Composite Instances"
    },
    {
      "code" : "device-id",
      "display" : "Device ID",
      "definition" : "User-supplied identifier for the device"
    },
    {
      "code" : "study-instance-uid",
      "display" : "Study Instance UID",
      "definition" : "Unique identifier for the Study"
    },
    {
      "code" : "sop-instance-uid",
      "display" : "SOP Instance UID",
      "definition" : "Uniquely identifies the SOP Instance"
    }
  ]
}

```
