# RDSC Actor requirements - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## CapabilityStatement: RDSC Actor requirements 

 
Defines the operations requirements for RDSC actor 

The Radiation Dose Summary Consumer actor shall follow this Capability Statement. This Capability Statement does not describe the specific interpretation or identify the stakeholders that will access the different radiation resources. These details are established locally, in accordance with local policies and jurisdictional requirements. The following Capability Statement only describes FHIR capabilities necessary to access the different resources.

 [Raw OpenAPI-Swagger Definition file](../RDSC.openapi.json) | [Download](../RDSC.openapi.json) 

## RDSC Actor requirements

* Implementation Guide Version: 1.0.0 
* FHIR Version: 4.0.1 
* Supported Formats: `xml`, `json`
* Published on: 2021-06-28 
* Published by: HL7 International / Imaging Integration 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary](index.md)

## FHIR RESTful Capabilities

### Mode: client

Description of the needed resources to be supported by the RDSC actor.

**Summary of System-wide Interactions**

* Supports the `transaction`interaction.
* Supports the `search-system`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Patient](#Patient1-1) |   | **Y** |  |  |  |  |  |  |  |
| [Practitioner](#Practitioner1-2) |   | **Y** |  |  |  |  |  |  |  |
| [ImagingStudy](#ImagingStudy1-3) |   | **Y** |  |  |  |  |  |  |  |
| [Device](#Device1-4) |   | **Y** |  |  |  |  |  |  |  |
| [Observation](#Observation1-5) |   | **Y** | **Y** |  |  | identifier, code, patient, device, part-of, date |  |  |  |

-------

#### Resource Conformance: SHALL Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Documentation
> 

Read patient information.


#### Resource Conformance: SHALL Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Documentation
> 

Read practitioner information.


#### Resource Conformance: SHALL ImagingStudy

Core FHIR Resource

[ImagingStudy](http://hl7.org/fhir/R4/imagingstudy.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Documentation
> 

Read ImagingStudy information.


#### Resource Conformance: SHALL Device

Core FHIR Resource

[Device](http://hl7.org/fhir/R4/device.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Documentation
> 

Read Device information.


#### Resource Conformance: SHALL Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* **SHALL** support `read`, `search-type`.

Search Parameters


 

## FHIR Document Capabilities

| | | |
| :--- | :--- | :--- |
| producer | [Radiation Summary Report](StructureDefinition-radiation-summary-report.md) | Documents related to Radiation Summary Report profile. |



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "RDSC",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "ii"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/uv/radiation-dose-summary/CapabilityStatement/RDSC",
  "version" : "1.0.0",
  "name" : "RDSC",
  "title" : "RDSC Actor requirements",
  "status" : "active",
  "date" : "2021-06-28",
  "publisher" : "HL7 International / Imaging Integration",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "HL7 Imaging Integration Workgroup",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/imagemgt"
        }
      ]
    },
    {
      "name" : "Abderrazek Boufahja",
      "telecom" : [
        {
          "system" : "email",
          "value" : "abderrazek.boufahja@gehealthcare.com"
        }
      ]
    }
  ],
  "description" : "Defines the operations requirements for RDSC actor",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/uv/radiation-dose-summary/ImplementationGuide/hl7.fhir.uv.radiation-dose-summary"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "Description of the needed resources to be supported by the RDSC actor.",
      "resource" : [
        {
          "type" : "Patient",
          "documentation" : "Read patient information.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "documentation" : "Read practitioner information.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "ImagingStudy",
          "documentation" : "Read ImagingStudy information.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Device",
          "documentation" : "Read Device information.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Observation",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "code",
              "type" : "token",
              "documentation" : "Search based on identifiers of radiation dose summary like Accession Number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "type" : "reference",
              "documentation" : "Search based on patient identifier"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "device",
              "type" : "token",
              "documentation" : "Search based on modality identifiers"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "part-of",
              "type" : "reference",
              "documentation" : "Search based on ImagingStudy"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "date",
              "type" : "date",
              "documentation" : "Search based on Radiation Summary effective dateTime, can be used to search for radiation through a period of time"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction"
        },
        {
          "code" : "search-system"
        }
      ]
    }
  ],
  "document" : [
    {
      "mode" : "producer",
      "documentation" : "Documents related to Radiation Summary Report profile.",
      "profile" : "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-summary-report"
    }
  ]
}

```
