# Bundle_RDS_resources - Radiation Dose Summary for Diagnostic Procedures on FHIR v1.0.0

## Bundle: Bundle_RDS_resources

Language: en

Bundle Bundle-RDS-resources of type transaction

-------

Entry 1 - fullUrl = urn:uuid:31f5c227-259e-4741-be3c-0d61b8b8d434

Resource Observation:

> 

Language: en

Profile: [Radiation Dose Summary](StructureDefinition-radiation-dose-summary.md)

**partOf**:[ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25,Accession ID: AN1232234; status = available; started = 2019-01-23 11:45:30+0000](Bundle-Bundle-RDS-resources.md#urn-uuid-f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1)**status**: Final**code**:Radiation exposure and protection information [Description] Document Diagnostic imaging**subject**:[Pascale Dupont](Bundle-Bundle-RDS-resources.md#urn-uuid-9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f)**focus**:[ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25,Accession ID: AN1232234; status = available; started = 2019-01-23 11:45:30+0000](Bundle-Bundle-RDS-resources.md#urn-uuid-f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1)**effective**: 2019-01-23 12:00:30+0000**performer**:[John Moore](Bundle-Bundle-RDS-resources.md#urn-uuid-a7176373-e7e3-49ff-9d1f-fb977a4dd88f)**value**: X-ray angiography performed, total dose 212 mGy**device**:[XA01](Bundle-Bundle-RDS-resources.md#urn-uuid-c7627fe7-c072-4b9e-a4ee-94939b41664e)
> **component****code**:Procedure reported**value**:Projection X-Ray

> **component****code**:Dose (RP) Total**value**: 212 mGy

> **component****code**:Dose Area Product Total**value**: 13639 mGy.cm2

> **component****code**:Total Fluoro Time**value**: 450 s

Request:

```
POST Observation

```

-------

Entry 2 - fullUrl = urn:uuid:9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f

Resource Patient:

> 

Language: en

Pascale Dupony Female, DoB: 1990-03-18 ( urn:pid:ipdauth1#PAT3421)
-------

Request:

```
POST Patient

```

-------

Entry 3 - fullUrl = urn:uuid:a7176373-e7e3-49ff-9d1f-fb977a4dd88f

Resource Practitioner:

> 

Language: en

**identifier**:`urn:prid:ipractauth1`/pract67**name**: John Moore

Request:

```
POST Practitioner

```

-------

Entry 4 - fullUrl = urn:uuid:c7627fe7-c072-4b9e-a4ee-94939b41664e

Resource Device:

> 

Language: en

Profile: [Modality Device](StructureDefinition-modality-device.md)

**identifier**: Serial Number/767ER, Application Entity/XA01**manufacturer**: Manufacturer-1**serialNumber**: 767ER**type**:X-Ray Angiography

Request:

```
POST Device

```

-------

Entry 5 - fullUrl = urn:uuid:f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1

Resource ImagingStudy:

> 

Language: en

**identifier**:[DICOM Unique Id](http://terminology.hl7.org/6.2.0/NamingSystem-dui.html)/urn:oid:1.2.840.121.3.32.0.1.25, Accession ID/AN1232234**status**: Available**subject**:[Pascale Dupont](Bundle-Bundle-RDS-resources.md#urn-uuid-9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f)**started**: 2019-01-23 11:45:30+0000

Request:

```
POST ImagingStudy

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "Bundle-RDS-resources",
  "language" : "en",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:31f5c227-259e-4741-be3c-0d61b8b8d434",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/radiation-dose-summary"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-radiation-dose-summary.html\">Radiation Dose Summary</a></p></div><p><b>partOf</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1\">ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25,Accession ID: AN1232234; status = available; started = 2019-01-23 11:45:30+0000</a></p><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 73569-6}\">Radiation exposure and protection information [Description] Document Diagnostic imaging</span></p><p><b>subject</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f\">Pascale Dupont</a></p><p><b>focus</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1\">ImagingStudy: identifier = urn:dicom:uid#DICOM Unique Id#urn:oid:1.2.840.121.3.32.0.1.25,Accession ID: AN1232234; status = available; started = 2019-01-23 11:45:30+0000</a></p><p><b>effective</b>: 2019-01-23 12:00:30+0000</p><p><b>performer</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-a7176373-e7e3-49ff-9d1f-fb977a4dd88f\">John Moore</a></p><p><b>value</b>: X-ray angiography performed, total dose 212 mGy</p><p><b>device</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-c7627fe7-c072-4b9e-a4ee-94939b41664e\">XA01</a></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM 121058}\">Procedure reported</span></p><p><b>value</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM 113704}\">Projection X-Ray</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM 113725}\">Dose (RP) Total</span></p><p><b>value</b>: 212 mGy</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM 113722}\">Dose Area Product Total</span></p><p><b>value</b>: 13639 mGy.cm2</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM 113730}\">Total Fluoro Time</span></p><p><b>value</b>: 450 s</p></blockquote></div>"
        },
        "partOf" : [
          {
            "reference" : "urn:uuid:f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1",
            "identifier" : {
              "type" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
                    "code" : "study-instance-uid",
                    "display" : "Study Instance UID"
                  }
                ]
              },
              "system" : "urn:dicom:uid",
              "value" : "urn:oid:1.2.840.121.3.32.0.1.25"
            }
          }
        ],
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "73569-6",
              "display" : "Radiation exposure and protection information [Description] Document Diagnostic imaging"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f",
          "display" : "Pascale Dupont"
        },
        "focus" : [
          {
            "reference" : "urn:uuid:f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1"
          }
        ],
        "effectiveDateTime" : "2019-01-23T12:00:30.000Z",
        "performer" : [
          {
            "reference" : "urn:uuid:a7176373-e7e3-49ff-9d1f-fb977a4dd88f",
            "display" : "John Moore"
          }
        ],
        "valueString" : "X-ray angiography performed, total dose 212 mGy",
        "device" : {
          "reference" : "urn:uuid:c7627fe7-c072-4b9e-a4ee-94939b41664e",
          "display" : "XA01"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://dicom.nema.org/resources/ontology/DCM",
                  "code" : "121058",
                  "display" : "Procedure reported"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://dicom.nema.org/resources/ontology/DCM",
                  "code" : "113704",
                  "display" : "Projection X-Ray"
                }
              ]
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://dicom.nema.org/resources/ontology/DCM",
                  "code" : "113725",
                  "display" : "Dose (RP) Total"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 212,
              "unit" : "mGy"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://dicom.nema.org/resources/ontology/DCM",
                  "code" : "113722",
                  "display" : "Dose Area Product Total"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 13639,
              "unit" : "mGy.cm2"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://dicom.nema.org/resources/ontology/DCM",
                  "code" : "113730",
                  "display" : "Total Fluoro Time"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 450,
              "unit" : "s"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f",
      "resource" : {
        "resourceType" : "Patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient </b></p><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Pascale Dupony  Female, DoB: 1990-03-18 ( urn:pid:ipdauth1#PAT3421)</p><hr/></div>"
        },
        "identifier" : [
          {
            "system" : "urn:pid:ipdauth1",
            "value" : "PAT3421"
          }
        ],
        "name" : [
          {
            "family" : "Dupony",
            "given" : ["Pascale"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1990-03-18"
      },
      "request" : {
        "method" : "POST",
        "url" : "Patient"
      }
    },
    {
      "fullUrl" : "urn:uuid:a7176373-e7e3-49ff-9d1f-fb977a4dd88f",
      "resource" : {
        "resourceType" : "Practitioner",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner </b></p><p><b>identifier</b>: <code>urn:prid:ipractauth1</code>/pract67</p><p><b>name</b>: John Moore </p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:prid:ipractauth1",
            "value" : "pract67"
          }
        ],
        "name" : [
          {
            "family" : "Moore",
            "given" : ["John"]
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Practitioner"
      }
    },
    {
      "fullUrl" : "urn:uuid:c7627fe7-c072-4b9e-a4ee-94939b41664e",
      "resource" : {
        "resourceType" : "Device",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/radiation-dose-summary/StructureDefinition/modality-device"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Device </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-modality-device.html\">Modality Device</a></p></div><p><b>identifier</b>: Serial Number/767ER, Application Entity/XA01</p><p><b>manufacturer</b>: Manufacturer-1</p><p><b>serialNumber</b>: 767ER</p><blockquote><p><b>deviceName</b></p><p><b>name</b>: Manufacturer-1</p><p><b>type</b>: Manufacturer name</p></blockquote><blockquote><p><b>deviceName</b></p><p><b>name</b>: Manufacturer-ModelName-1</p><p><b>type</b>: Model name</p></blockquote><p><b>type</b>: <span title=\"Codes:{http://dicom.nema.org/resources/ontology/DCM XA}\">X-Ray Angiography</span></p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "SNO",
                  "display" : "Serial Number"
                }
              ]
            },
            "value" : "767ER"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/radiation-dose-summary/CodeSystem/dicom-identifier-type",
                  "code" : "application-entity",
                  "display" : "Application Entity"
                }
              ]
            },
            "value" : "XA01"
          }
        ],
        "manufacturer" : "Manufacturer-1",
        "serialNumber" : "767ER",
        "deviceName" : [
          {
            "name" : "Manufacturer-1",
            "type" : "manufacturer-name"
          },
          {
            "name" : "Manufacturer-ModelName-1",
            "type" : "model-name"
          }
        ],
        "type" : {
          "coding" : [
            {
              "system" : "http://dicom.nema.org/resources/ontology/DCM",
              "code" : "XA",
              "display" : "X-Ray Angiography"
            }
          ]
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Device"
      }
    },
    {
      "fullUrl" : "urn:uuid:f1738bb1-6f51-4d6b-ad7a-d8c933cf0cf1",
      "resource" : {
        "resourceType" : "ImagingStudy",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ImagingStudy_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ImagingStudy </b></p><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-dui.html\" title=\"An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of &quot;urn:oid:&quot;. See https://www.dicomstandard.org/\">DICOM Unique Id</a>/urn:oid:1.2.840.121.3.32.0.1.25, Accession ID/AN1232234</p><p><b>status</b>: Available</p><p><b>subject</b>: <a href=\"Bundle-Bundle-RDS-resources.html#urn-uuid-9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f\">Pascale Dupont</a></p><p><b>started</b>: 2019-01-23 11:45:30+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:dicom:uid",
            "value" : "urn:oid:1.2.840.121.3.32.0.1.25"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "ACSN",
                  "display" : "Accession ID"
                }
              ]
            },
            "value" : "AN1232234"
          }
        ],
        "status" : "available",
        "subject" : {
          "reference" : "urn:uuid:9dbc81e1-99c1-4b9c-8a5b-1d37ee18312f",
          "display" : "Pascale Dupont"
        },
        "started" : "2019-01-23T11:45:30.000Z"
      },
      "request" : {
        "method" : "POST",
        "url" : "ImagingStudy"
      }
    }
  ]
}

```
