# QI-Core Terminology - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* **QI-Core Terminology**

## QI-Core Terminology

This page lists all the ValueSets, CodeSystems, and ConceptMaps defined as part of the QI-Core Implementation Guide. For more information on using codes in resources, see the [guidance section](http://hl7.org/fhir/us/core/STU7/general-requirements.html#using-codes-in-us-core-profiles) as well as in the [FHIR specification](http://hl7.org/fhir/terminologies.html).

Further guidance on using Value Set Authority Center (VSAC) Resources with FHIR® Terminology Service can be found [here.](http://hl7.org/fhir/us/core/STU7/terminology.html#using-value-set-authority-center-vsac)

### Value Set Resources

These value sets have been defined for this implementation guide.

| | |
| :--- | :--- |
| [QICore SNOMED CT Dosage Codes](ValueSet-qicore-medication-dose-type.md) | This value set includes all the "Dosages" SNOMED CT codes (i.e. codes with an is-a relationship with 277406006: Dosages). |
| [QICore Negation Reason Codes](ValueSet-qicore-negation-reason.md) | This value set defines the set of codes that can be used to indicate the reason an action was not taken |
| [QICore Observation Body Position](ValueSet-qicore-observation-body-position.md) | SNOMED CT code system values descending from the following:'body position finding' 9851009 |
| [Positive Event Status](ValueSet-qicore-positive-event-status.md) | This value set defines the set of codes that indicate a positive event status (i.e. codes that indicate an event is in preparation, progress, on-hold, stopped, or has completed) |
| [Positive MedicationAdministration Status](ValueSet-qicore-positive-medication-admin-status.md) | This value set defines the set of codes that indicate a positive medication administration status (i.e. codes that indicate at least some medication is being or was administered) |
| [Positive MedicationDispense Status](ValueSet-qicore-positive-medicationdispense-status.md) | This value set defines the set of codes that indicate a positive medication dispense status (i.e. codes that indicate at least some medication was dispensed) |
| [Positive MedicationRequest Status](ValueSet-qicore-positive-medicationrequest-status.md) | This value set defines the set of codes that indicate a positive medication request status (i.e. codes that a medication is proposed, planned, or ordered) |
| [Positive Request Status](ValueSet-qicore-positive-request-status.md) | This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered). |
| [Positive Task Status](ValueSet-qicore-positive-task-status.md) | This value set defines the set of codes that indicate a positive task status |
| [QICore Present On Admission Codes](ValueSet-qicore-present-on-admission.md) | Value Set for QICore Present On Admission. |

### CodeSystem Resources

See the [FHIR terminology section](http://hl7.org/fhir/terminologies-systems.html) for a complete discussion on code systems and a list of codes system names used in FHIR. The following additional names (URIs) have been identified for this implementation guide.

**Code systems published in this IG**

|
|

