# hl7.fhir.us.qicore#7.0.2: QI-Core Implementation Guide

## Pages

* [Quality Improvement Core (QI-Core) Implementation Guide](index.md)
* [QI-Core Examples](examples.md)
* [QI-Core Extensions](extensions.md)
* [Model Info](modelinfo.md)
* [QI-Core Terminology](terminology.md)
* [QI Key Elements](qi-elements.md)
* [Changes](changes.md)
* [QI-Core Profiles](profiles.md)
* [Quality Data Model (QDM)v5.6 to QI-Core R7 Mapping](qdm-to-qicore.md)
* [QI-Core Patterns](patterns.md)
* [QI-Core Negation](negation.md)
* [Artifacts Summary](artifacts.md)
* [QI-Core Downloads](downloads.md)

## Resources

### ValueSets

* [QICore SNOMED CT Dosage Codes](ValueSet-qicore-medication-dose-type.md)
* [QICore Negation Reason Codes](ValueSet-qicore-negation-reason.md)
* [QICore Observation Body Position](ValueSet-qicore-observation-body-position.md)
* [Positive Event Status](ValueSet-qicore-positive-event-status.md)
* [Positive MedicationAdministration Status](ValueSet-qicore-positive-medication-admin-status.md)
* [Positive MedicationDispense Status](ValueSet-qicore-positive-medicationdispense-status.md)
* [Positive MedicationRequest Status](ValueSet-qicore-positive-medicationrequest-status.md)
* [Positive Request Status](ValueSet-qicore-positive-request-status.md)
* [Positive Task Status](ValueSet-qicore-positive-task-status.md)
* [QICore Present On Admission Codes](ValueSet-qicore-present-on-admission.md)

### Resource Profiles

* [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md)
* [QICore AllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md)
* [QICore BodyStructure](StructureDefinition-qicore-bodystructure.md)
* [QICore CarePlan](StructureDefinition-qicore-careplan.md)
* [QICore CareTeam](StructureDefinition-qicore-careteam.md)
* [QICore Claim](StructureDefinition-qicore-claim.md)
* [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md)
* [QICore Communication](StructureDefinition-qicore-communication.md)
* [QICore CommunicationDone](StructureDefinition-qicore-communicationdone.md)
* [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md)
* [QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md)
* [QICore Condition Encounter Diagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md)
* [QICore Condition Problems Health Concerns](StructureDefinition-qicore-condition-problems-health-concerns.md)
* [QICore Coverage](StructureDefinition-qicore-coverage.md)
* [QICore Device](StructureDefinition-qicore-device.md)
* [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md)
* [QICore DeviceRequest](StructureDefinition-qicore-devicerequest.md)
* [QICore DeviceRequested](StructureDefinition-qicore-devicerequested.md)
* [QICore DeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md)
* [QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md)
* [QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md)
* [QICore Encounter](StructureDefinition-qicore-encounter.md)
* [QICore FamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md)
* [QICore Flag](StructureDefinition-qicore-flag.md)
* [QICore Goal](StructureDefinition-qicore-goal.md)
* [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md)
* [QICore Immunization](StructureDefinition-qicore-immunization.md)
* [QICore Immunization Done](StructureDefinition-qicore-immunizationdone.md)
* [QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md)
* [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md)
* [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md)
* [QICore Location](StructureDefinition-qicore-location.md)
* [QICore Medication](StructureDefinition-qicore-medication.md)
* [QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md)
* [QICore MedicationAdministration Done](StructureDefinition-qicore-medicationadministrationdone.md)
* [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md)
* [QICore MedicationDispense](StructureDefinition-qicore-medicationdispense.md)
* [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md)
* [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md)
* [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md)
* [QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md)
* [QICore MedicationRequested](StructureDefinition-qicore-medicationrequested.md)
* [QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md)
* [QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md)
* [QICore NutritionOrder](StructureDefinition-qicore-nutritionorder.md)
* [QICore Observation Clinical Result](StructureDefinition-qicore-observation-clinical-result.md)
* [QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md)
* [QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md)
* [QICore Organization](StructureDefinition-qicore-organization.md)
* [QICore Patient](StructureDefinition-qicore-patient.md)
* [QICore Practitioner](StructureDefinition-qicore-practitioner.md)
* [QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md)
* [QICore Procedure](StructureDefinition-qicore-procedure.md)
* [QICore Procedure Done](StructureDefinition-qicore-proceduredone.md)
* [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md)
* [QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md)
* [QICore RelatedPerson](StructureDefinition-qicore-relatedperson.md)
* [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md)
* [QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)
* [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)
* [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* [QICore Substance](StructureDefinition-qicore-substance.md)
* [QICore Task](StructureDefinition-qicore-task.md)
* [QICore Task Done](StructureDefinition-qicore-taskdone.md)
* [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)

### Extensions

* [Code Options](StructureDefinition-codeOptions.md)
* [QI-Core Key Element Extension](StructureDefinition-qicore-keyelement.md)

### Conditions

* [appendicitis-example](Condition-appendicitis-example.md)

### ImplementationGuides

* [QI-Core Implementation Guide](index.md)

### Libraries

* [QICore Model Definition](Library-QICore-ModelInfo.md)

### Examples

* [example (AdverseEvent)](AdverseEvent-example.md)
* [example-refuted (AllergyIntolerance)](AllergyIntolerance-example-refuted.md)
* [example (AllergyIntolerance)](AllergyIntolerance-example.md)
* [example (BodyStructure)](BodyStructure-example.md)
* [example (CarePlan)](CarePlan-example.md)
* [example (CareTeam)](CareTeam-example.md)
* [example (Claim)](Claim-example.md)
* [example (ClaimResponse)](ClaimResponse-example.md)
* [done-example (Communication)](Communication-done-example.md)
* [example (Communication)](Communication-example.md)
* [negation-example (Communication)](Communication-negation-example.md)
* [example (CommunicationRequest)](CommunicationRequest-example.md)
* [example (Condition)](Condition-example.md)
* [health-concern-example (Condition)](Condition-health-concern-example.md)
* [example-new (Coverage)](Coverage-example-new.md)
* [example (Coverage)](Coverage-example.md)
* [example (Device)](Device-example.md)
* [example (DeviceRequest)](DeviceRequest-example.md)
* [negation-example (DeviceRequest)](DeviceRequest-negation-example.md)
* [negation-with-code-example (DeviceRequest)](DeviceRequest-negation-with-code-example.md)
* [requested-example (DeviceRequest)](DeviceRequest-requested-example.md)
* [example (DeviceUseStatement)](DeviceUseStatement-example.md)
* [example (DiagnosticReport)](DiagnosticReport-example.md)
* [note-example (DiagnosticReport)](DiagnosticReport-note-example.md)
* [encounter-ed-example (Encounter)](Encounter-encounter-ed-example.md)
* [example (Encounter)](Encounter-example.md)
* [example (FamilyMemberHistory)](FamilyMemberHistory-example.md)
* [example (Flag)](Flag-example.md)
* [example (Goal)](Goal-example.md)
* [example (ImagingStudy)](ImagingStudy-example.md)
* [done-example (Immunization)](Immunization-done-example.md)
* [example (Immunization)](Immunization-example.md)
* [negation-example-code (Immunization)](Immunization-negation-example-code.md)
* [negation-example (Immunization)](Immunization-negation-example.md)
* [example (ImmunizationEvaluation)](ImmunizationEvaluation-example.md)
* [example (ImmunizationRecommendation)](ImmunizationRecommendation-example.md)
* [South Wing, second floor (Location)](Location-example.md)
* [example (Medication)](Medication-example.md)
* [cmd-example (MedicationAdministration)](MedicationAdministration-cmd-example.md)
* [done-example (MedicationAdministration)](MedicationAdministration-done-example.md)
* [example (MedicationAdministration)](MedicationAdministration-example.md)
* [negation-example (MedicationAdministration)](MedicationAdministration-negation-example.md)
* [negation-with-code-example (MedicationAdministration)](MedicationAdministration-negation-with-code-example.md)
* [cmd-example (MedicationDispense)](MedicationDispense-cmd-example.md)
* [done-example (MedicationDispense)](MedicationDispense-done-example.md)
* [example (MedicationDispense)](MedicationDispense-example.md)
* [negation-example (MedicationDispense)](MedicationDispense-negation-example.md)
* [negation-with-code-example (MedicationDispense)](MedicationDispense-negation-with-code-example.md)
* [cmd-example (MedicationRequest)](MedicationRequest-cmd-example.md)
* [example (MedicationRequest)](MedicationRequest-example.md)
* [negation-example-code (MedicationRequest)](MedicationRequest-negation-example-code.md)
* [negation-example (MedicationRequest)](MedicationRequest-negation-example.md)
* [patient-reported-example (MedicationRequest)](MedicationRequest-patient-reported-example.md)
* [patient-requester-example (MedicationRequest)](MedicationRequest-patient-requester-example.md)
* [practitioner-ordered-example (MedicationRequest)](MedicationRequest-practitioner-ordered-example.md)
* [requested-example (MedicationRequest)](MedicationRequest-requested-example.md)
* [example (MedicationStatement)](MedicationStatement-example.md)
* [example (NutritionOrder)](NutritionOrder-example.md)
* [clinical-result-heart-rate-rhythm (Observation)](Observation-clinical-result-heart-rate-rhythm.md)
* [example-births (Observation)](Observation-example-births.md)
* [example-delivery-date-estimate (Observation)](Observation-example-delivery-date-estimate.md)
* [example-frailty (Observation)](Observation-example-frailty.md)
* [example-gestation (Observation)](Observation-example-gestation.md)
* [example-nonpatient-hemodialysis-machine (Observation)](Observation-example-nonpatient-hemodialysis-machine.md)
* [example-nonpatient-hospital-bed (Observation)](Observation-example-nonpatient-hospital-bed.md)
* [example-nonpatient-mechanical-ventilator (Observation)](Observation-example-nonpatient-mechanical-ventilator.md)
* [example-obstetric-delivery (Observation)](Observation-example-obstetric-delivery.md)
* [example-odh (Observation)](Observation-example-odh.md)
* [example-parity (Observation)](Observation-example-parity.md)
* [example-pregnancies (Observation)](Observation-example-pregnancies.md)
* [example-preterm-births (Observation)](Observation-example-preterm-births.md)
* [example-screening-assessment-10-minute-apgar-heart-rate (Observation)](Observation-example-screening-assessment-10-minute-apgar-heart-rate.md)
* [example (Observation)](Observation-example.md)
* [laboratory-result-observation-example-blood-glucose (Observation)](Observation-laboratory-result-observation-example-blood-glucose.md)
* [Health Level Seven International (Organization)](Organization-example.md)
* [HENDRICKS COUNTY HOSPITAL (Organization)](Organization-example1.md)
* [qicore-modelinfosettings (Parameters)](Parameters-qicore-modelinfosettings.md)
* [example-2 (Patient)](Patient-example-2.md)
* [example (Patient)](Patient-example.md)
* [infant-example (Patient)](Patient-infant-example.md)
* [example (Practitioner)](Practitioner-example.md)
* [example (PractitionerRole)](PractitionerRole-example.md)
* [done-example (Procedure)](Procedure-done-example.md)
* [example (Procedure)](Procedure-example.md)
* [negation-example (Procedure)](Procedure-negation-example.md)
* [negation-with-code-example (Procedure)](Procedure-negation-with-code-example.md)
* [PHQ-9-example (QuestionnaireResponse)](QuestionnaireResponse-PHQ-9-example.md)
* [example (RelatedPerson)](RelatedPerson-example.md)
* [appropriateness-example (ServiceRequest)](ServiceRequest-appropriateness-example.md)
* [elective-example (ServiceRequest)](ServiceRequest-elective-example.md)
* [example (ServiceRequest)](ServiceRequest-example.md)
* [myringotomy-example (ServiceRequest)](ServiceRequest-myringotomy-example.md)
* [negation-example-code (ServiceRequest)](ServiceRequest-negation-example-code.md)
* [negation-example (ServiceRequest)](ServiceRequest-negation-example.md)
* [proposal-example-code (ServiceRequest)](ServiceRequest-proposal-example-code.md)
* [proposal-example (ServiceRequest)](ServiceRequest-proposal-example.md)
* [servicerequested-example (ServiceRequest)](ServiceRequest-servicerequested-example.md)
* [example (Substance)](Substance-example.md)
* [done-example (Task)](Task-done-example.md)
* [example (Task)](Task-example.md)
* [negation-example (Task)](Task-negation-example.md)
* [negation-with-code-example (Task)](Task-negation-with-code-example.md)
* [rejected-example (Task)](Task-rejected-example.md)
* [rejected-with-code-example (Task)](Task-rejected-with-code-example.md)
