# Artifacts Summary - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Knowledge Artifacts: Libraries 

These define logic, asset collections and other libraries as part of content in this implementation guide.

| | |
| :--- | :--- |
| [QICore Model Definition](Library-QICore-ModelInfo.md) | Model definition for the QI-Core IG Model |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md) | Actual or potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death. |
| [QICore AllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md) | Profile of AllergyIntolerance for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore BodyStructure](StructureDefinition-qicore-bodystructure.md) | Profile of BodyStructure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore CarePlan](StructureDefinition-qicore-careplan.md) | The QI-Core CarePlan is based upon the US Core CarePlan Profile which is based upon the core FHIR CarePlan Resource and created to meet the 2015 Edition Common Clinical Data Set 'Assessment and Plan of Treatment requirements. Defines constraints and extensions on the CarePlan resource for the minimal set of data to query and retrieve a patient's Care Plan. |
| [QICore CareTeam](StructureDefinition-qicore-careteam.md) | Profile of CareTeam for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Claim](StructureDefinition-qicore-claim.md) | Profile of Claim for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md) | The QI-Core ClaimResponse profile is used to provide the results of the adjudication and/or authorization of a set of healthcare-related products and services for a patient against the patient's insurance coverages, or to respond with what the adjudication would be for a supplied set of products or services should they be actually supplied to the patient. It identifies the mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the ClaimResponse resource when using this profile |
| [QICore Communication](StructureDefinition-qicore-communication.md) | Profile of Communication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md) | Negation profile of Communication for decision support/quality metrics. Indicates that the communication was not performed for a reason. |
| [QICore CommunicationDone](StructureDefinition-qicore-communicationdone.md) | Positive profile of Communication for decision support/quality metrics. Indicates that the communication was performed (as opposed to the not done profile). |
| [QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md) | Profile of CommunicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Condition Encounter Diagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md) | The QI-Core Condition Encounter Diagnosis Profile is based upon the US Core Condition Encounter Diagnosis Profile. In version 5.0.0, the QI-Core Condition Profile has been split into the QI-Core Condition Encounter Diagnosis Profile and QI-Core Condition Problems and Health Concerns Profile. To promote interoperability and adoption through consistent implementation, this profile defines constraints and extensions on the Condition resource for the minimal set of data to record, search, and retrieve information about an encounter diagnosis. It defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Condition Problems Health Concerns](StructureDefinition-qicore-condition-problems-health-concerns.md) | Profile of Condition for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Coverage](StructureDefinition-qicore-coverage.md) | Profile of Coverage for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Device](StructureDefinition-qicore-device.md) | Profile of Device for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md) | Negation profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a device. |
| [QICore DeviceRequest](StructureDefinition-qicore-devicerequest.md) | Profile of DeviceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore DeviceRequested](StructureDefinition-qicore-devicerequested.md) | Positive profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order for a device. |
| [QICore DeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md) | Profile of DeviceUseStatement for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md) | Profile of DiagnosticReport for laboratory results for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md) | Profile of DiagnosticReport for Note exchange for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Encounter](StructureDefinition-qicore-encounter.md) | Profile of Encounter for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore FamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md) | Profile of Family Member History for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Flag](StructureDefinition-qicore-flag.md) | Profile of Flag for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Goal](StructureDefinition-qicore-goal.md) | Profile of Goal for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md) | Profile of ImagingStudy for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Immunization](StructureDefinition-qicore-immunization.md) | Profile of Immunization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Immunization Done](StructureDefinition-qicore-immunizationdone.md) | Positive profile of Immunization for decision support/quality metrics. Indicates that the immunization is being or was performed (as opposed to the not done profile). |
| [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md) | Negation profile of Communication for decision support/quality metrics. Indicates that the communication was not performed for a reason. |
| [QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md) | Defines constraints and extensions on the ImmunizationEvaluation resource for the minimal set of data to query and retrieve a patient's Immunization Evaluation. |
| [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md) | Profile of ImmunizationRecommendation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md) | The QI-Core Laboratory Result Observation Profile is based upon the US Laboratory Result Observation Resource. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Location](StructureDefinition-qicore-location.md) | Profile of Location for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Medication](StructureDefinition-qicore-medication.md) | Profile of Medication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md) | Negation profile of MedicationRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a medication. |
| [QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md) | Profile of MedicationAdministration for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore MedicationAdministration Done](StructureDefinition-qicore-medicationadministrationdone.md) | Positive profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication administration is being or was performed (as opposed to the negative profile) |
| [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md) | Negation profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication was not administered for a reason. |
| [QICore MedicationDispense](StructureDefinition-qicore-medicationdispense.md) | Profile of MedicationDispense for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md) | Negation profile of MedicationDispense for decision support/quality metrics. Indicates that a medication dispense was declined for a reason. |
| [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md) | Positive profile of MedicationDispense for decision support/quality metrics. Indicates that a medication is being or was dispensed |
| [QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md) | Profile of MedicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore MedicationRequested](StructureDefinition-qicore-medicationrequested.md) | Positive profile of MedicationRequest for decision support/quality metrics. Indicates that a medication was proposed, planned, or ordered. |
| [QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md) | Profile of MedicationStatement for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md) | Profile of NonPatient Observation for decision support/quality metrics evaluating resource use and availability rather than focusing on patients. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore NutritionOrder](StructureDefinition-qicore-nutritionorder.md) | Defines constraints and extensions on the NutritionOrder resource for the minimal set of data to query and retrieve a patient's Nutrition Order. |
| [QICore Observation Clinical Result](StructureDefinition-qicore-observation-clinical-result.md) | This profile sets minimum expectations for the Observation resource to record and search non-laboratory clinical test results (e.g., radiology and other clinical observations generated from procedures). An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy. This profile is the basis for the US Core Clinical Result Profile, which defines additional data elements to record and search laboratory test results. |
| [QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md) | The QI-Core Observation Screening Assessment Profile is based upon the US Core Observation Screening Assessment Profile which can be used to represent individual responses, panels of multi-question surveys, and multi-select responses to “check all that apply” questions. The QI-Core Observation Survey Profile sets minimum expectations for the Observation Resource to record, search, and fetch retrieve observations that represent the questions and responses to form/survey and defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Organization](StructureDefinition-qicore-organization.md) | Profile of Organization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Patient](StructureDefinition-qicore-patient.md) | Profile of Patient for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Practitioner](StructureDefinition-qicore-practitioner.md) | Profile of Practitioner for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md) | Profile of PractitionerRole for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Procedure](StructureDefinition-qicore-procedure.md) | Profile of Procedure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Procedure Done](StructureDefinition-qicore-proceduredone.md) | Positive profile of Procedure for decision support/quality metrics. Indicates that a procedure is being or was performed. |
| [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md) | Negative profile of Procedure for decision support/quality metrics. Indicates that a procedure was not done for a reason. |
| [QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md) | The QI-Core QuestionnaireResponse Profile is based upon the US Core QuestionnaireResponse Profile and sets minimum expectations for the QuestionnaireResponse resource to record, search, and fetch retrieve captures the responses to form/survey and defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore RelatedPerson](StructureDefinition-qicore-relatedperson.md) | Profile of RelatedPerson for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md) | Negation profile of ServiceRequest for decision support/quality metrics. Indicates a request not to provide a service |
| [QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md) | Profile of ServiceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md) | Positive profile of ServiceRequest for decision support/quality metrics. Indicates that a service is proposed, planned, or ordered. |
| [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md) | Profile of Simple Observation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Substance](StructureDefinition-qicore-substance.md) | Profile of Substance for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Task](StructureDefinition-qicore-task.md) | Profile of Task for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |
| [QICore Task Done](StructureDefinition-qicore-taskdone.md) | Positive profile of Task for decision support/quality metrics. Indicates a task that with a positive status |
| [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md) | Profile of TaskRejected for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Code Options](StructureDefinition-codeOptions.md) | A logical reference (i.e. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values used to convey a higher level concept that encompasses a list of candidate specializations when there is no formal code defined for that purpose. For example, the concept of COVID preventative medications can be expressed as a value set because there is no specific code representing that concept. |
| [QI-Core Key Element Extension](StructureDefinition-qicore-keyelement.md) | **This extension is only used in the QI-Core Implementation Guide's Profile StructureDefinition elements.**It flags elements that the quality improvement community has identified as significant to express the full intent of measures or decision support artifacts. See the[MustSupport Flag](index.md#mustsupport-flag)section in this IG for more information. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Positive Event Status](ValueSet-qicore-positive-event-status.md) | This value set defines the set of codes that indicate a positive event status (i.e. codes that indicate an event is in preparation, progress, on-hold, stopped, or has completed) |
| [Positive MedicationAdministration Status](ValueSet-qicore-positive-medication-admin-status.md) | This value set defines the set of codes that indicate a positive medication administration status (i.e. codes that indicate at least some medication is being or was administered) |
| [Positive MedicationDispense Status](ValueSet-qicore-positive-medicationdispense-status.md) | This value set defines the set of codes that indicate a positive medication dispense status (i.e. codes that indicate at least some medication was dispensed) |
| [Positive MedicationRequest Status](ValueSet-qicore-positive-medicationrequest-status.md) | This value set defines the set of codes that indicate a positive medication request status (i.e. codes that a medication is proposed, planned, or ordered) |
| [Positive Request Status](ValueSet-qicore-positive-request-status.md) | This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered). |
| [Positive Task Status](ValueSet-qicore-positive-task-status.md) | This value set defines the set of codes that indicate a positive task status |
| [QICore Negation Reason Codes](ValueSet-qicore-negation-reason.md) | This value set defines the set of codes that can be used to indicate the reason an action was not taken |
| [QICore Observation Body Position](ValueSet-qicore-observation-body-position.md) | SNOMED CT code system values descending from the following:'body position finding' 9851009 |
| [QICore Present On Admission Codes](ValueSet-qicore-present-on-admission.md) | Value Set for QICore Present On Admission. |
| [QICore SNOMED CT Dosage Codes](ValueSet-qicore-medication-dose-type.md) | This value set includes all the "Dosages" SNOMED CT codes (i.e. codes with an is-a relationship with 277406006: Dosages). |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [10 minute Apgar Heart Rate Observation Screening Assessment Example](Observation-example-screening-assessment-10-minute-apgar-heart-rate.md) | Example of a 10 minute Apgar Heart Rate Observation Screening Assessment |
| [65+ Female patient example](Patient-example-2.md) | 65+ Female patient example |
| [AdverseEvent example](AdverseEvent-example.md) | Example of an allergic reaction adverse event |
| [AllergyIntolerance example](AllergyIntolerance-example.md) | Example of a clinical assessment record of an allergy |
| [AllergyIntolerance refuted example](AllergyIntolerance-example-refuted.md) | Example of a clinical assessment record of an allergy that has been refuted |
| [BodyStructure example](BodyStructure-example.md) | Example of a BodyStructure resource to identify a mass in the spleen |
| [CarePlan example](CarePlan-example.md) | Example of an assessment and care plan for a pregnancy |
| [CareTeam example](CareTeam-example.md) | Example of a CareTeam involved in the delivery of care for a pregnancy |
| [Claim example](Claim-example.md) | Example of a vision claim |
| [ClaimResponse example](ClaimResponse-example.md) | Example of a vision claim response |
| [Communication example](Communication-example.md) | Example of a notification sent to a patient about an abnormal test result (using the General Communication profile) |
| [Communication negation example](Communication-negation-example.md) | Example of a notification that was not sent to a patient and reason why |
| [CommunicationDone example](Communication-done-example.md) | Example of a notification sent to a patient about an abnormal test result (using the Positive Communication profile) |
| [CommunicationRequest example](CommunicationRequest-example.md) | Example of a request to provide additional information for a claim |
| [Condition Encounter Diagnosis example](Condition-example.md) | Example of a condition encounter diagnosis resource used to record information about a burn of the left ear |
| [Condition Problems Health Concerns example](Condition-health-concern-example.md) | Example of a patient with a condition encounter health concern regarding obesity |
| [Condition example - appendicitis](Condition-appendicitis-example.md) | Example of a condition resource used to record information about an appendicitis |
| [Coverage example](Coverage-example.md) | Example of a coverage resource used to provide information about an individual's specific plan |
| [Coverage example - Subscriber ID](Coverage-example-new.md) | Example of a coverage resource used to provide information about an individual's specific plan with a Subscriber Id |
| [Date and time of obstetric delivery example](Observation-example-obstetric-delivery.md) | Example of a obstetric delivery datetime Observation |
| [Delivery date estimated example](Observation-example-delivery-date-estimate.md) | Example of a delivery date estimate Observation |
| [Device example](Device-example.md) | Device example for an ECG |
| [DeviceRequest general example](DeviceRequest-example.md) | Request to employ a medical device (using the General Profile) |
| [DeviceRequest negation with code example](DeviceRequest-negation-with-code-example.md) | Example of a request not to employ a specific medical device |
| [DeviceRequest negation with value set example](DeviceRequest-negation-example.md) | Example of a request not to employ any of a class of medical devices |
| [DeviceRequest positive example](DeviceRequest-requested-example.md) | Example of a request to employ a medical device (using the Positive Profile) |
| [DeviceUseStatement example](DeviceUseStatement-example.md) | Example of a record of device use by a patient |
| [DiagnosticReportLab example](DiagnosticReport-example.md) | Example of the findings and interpretation of a laboratory diagnostic test |
| [DiagnosticReportNote example](DiagnosticReport-note-example.md) | Example of a DiagnosticReport Note |
| [Encounter example](Encounter-example.md) | Example of an Encounter |
| [Encounter example of emergency visit that escalated into inpatient patient](Encounter-encounter-ed-example.md) | Encounter example of emergency visit that escalated into inpatient patient |
| [FamilyMemberHistory example](FamilyMemberHistory-example.md) | Example of Family Member History for a patient |
| [Flag example](Flag-example.md) | Warning/Notification when providing care example |
| [Frailty observation example](Observation-example-frailty.md) | Example of a frailty observation measure |
| [Gestation age at birth observation example](Observation-example-gestation.md) | Example of a gestation age at birth observation |
| [Glucose Laboratory Result Observation Example](Observation-laboratory-result-observation-example-blood-glucose.md) | Example of a glucose laboratory result observation |
| [Goal example](Goal-example.md) | Example of weight loss goal/objective for a patient |
| [Heart rate rhythm clinical result observation example](Observation-clinical-result-heart-rate-rhythm.md) | Example of a Heart rate rhythm clinical result observation |
| [Hemodialysis Machine Availability (physical object) Observation Example](Observation-example-nonpatient-hemodialysis-machine.md) | Example of hempdialysis machine availability nonpatient observation |
| [Hospital Bed Availability (physical object) Observation Example](Observation-example-nonpatient-hospital-bed.md) | Example of hospital bed availability nonpatient observation |
| [Hospital Organization example](Organization-example1.md) | Hendricks County Hospital example |
| [ImagingStudy example](ImagingStudy-example.md) | Example of ImagingStudy based on CT imaging study |
| [Immunization general example](Immunization-example.md) | Immunization example (using the General Profile) |
| [Immunization negation with code example](Immunization-negation-example-code.md) | Example of immunization that was refused/failed to be administered using code |
| [Immunization negation with value set example](Immunization-negation-example.md) | Example of immunization that was refused/failed to be administered using value set |
| [Immunization positive example](Immunization-done-example.md) | Immunization example (using the Positive Profile) |
| [ImmunizationEvaluaion example](ImmunizationEvaluation-example.md) | Example of ImmunizationEvaluation |
| [ImmunizationRecommendation example](ImmunizationRecommendation-example.md) | Example of ImmunizationRecommendation for Hepatitis A vaccine |
| [Infant patient example](Patient-infant-example.md) | Infant patient example |
| [Location example](Location-example.md) | Example of Location of a provider - south wing of Mean Joe Greene University Medical Center |
| [Mechanical Ventilator Availability (physical object) Observation Example](Observation-example-nonpatient-mechanical-ventilator.md) | Example of mechanical ventilator availability nonpatient observation |
| [Medication example](Medication-example.md) | Example of Alemtuzumab Medication |
| [MedicationAdministration Cumulative Duration example](MedicationAdministration-cmd-example.md) | Cumulative Medication example of MedicationAdministration |
| [MedicationAdministration general example](MedicationAdministration-example.md) | Intravenous example of MedicationAdministration (using the General Profile) |
| [MedicationAdministration negation with code example](MedicationAdministration-negation-with-code-example.md) | Example of medication not administered using a code to indicate that a particular medication was not administered |
| [MedicationAdministration negation with value set example](MedicationAdministration-negation-example.md) | Example of medication not administered using a value set to indicate what was not administered |
| [MedicationAdministration positive example](MedicationAdministration-done-example.md) | Intravenous example of MedicationAdministration (using the Positive Profile) |
| [MedicationDispense cumulative dose example](MedicationDispense-cmd-example.md) | Cumulative Medication Dispense Example |
| [MedicationDispense general example](MedicationDispense-example.md) | Penicillin MedicationDispense Example (using the General Profile) |
| [MedicationDispense negation with code example](MedicationDispense-negation-with-code-example.md) | Example of medication not dispensed using a code to indicate the reason |
| [MedicationDispense negation with value set example](MedicationDispense-negation-example.md) | Example of medication not dispensed using a value set to indicate the reason |
| [MedicationDispense positive example](MedicationDispense-done-example.md) | Penicillin MedicationDispense Example (using the Positive Profile) |
| [MedicationProhibited using code example](MedicationRequest-negation-example-code.md) | Example of request not to provide a medication using a code |
| [MedicationProhibited using value set example](MedicationRequest-negation-example.md) | Example of request not to provide a medication using a value set |
| [MedicationRequest Cumulative Duration](MedicationRequest-cmd-example.md) | Cumulative Medication Duration Example |
| [MedicationRequest Patient Reported Example](MedicationRequest-patient-reported-example.md) | Patient Reported Example |
| [MedicationRequest Patient Requester Example](MedicationRequest-patient-requester-example.md) | Patient Requester Example |
| [MedicationRequest Practitioner Ordered Example](MedicationRequest-practitioner-ordered-example.md) | Practitioner Ordered Example |
| [MedicationRequest general example](MedicationRequest-example.md) | Penicillin MedicationRequest Example (using the General Profile) |
| [MedicationRequest positive example](MedicationRequest-requested-example.md) | Penicillin MedicationRequest Example (using the Positive Profile) |
| [MedicationStatment example](MedicationStatement-example.md) | Penicillin MedicationStatement Example |
| [Number of full-term births obeservation example](Observation-example-births.md) | Example number of full-term births Observation |
| [Number of parity obeservation example](Observation-example-parity.md) | Example number of parity Observation |
| [Number of pregnancies obeservation example](Observation-example-pregnancies.md) | Example number of pregnancies Observation |
| [Number of preterm births obeservation example](Observation-example-preterm-births.md) | Example number of preterm births Observation |
| [NutrientOrder example](NutritionOrder-example.md) | Example of NutrientOrder for diabetic diet |
| [ODH Observation example](Observation-example-odh.md) | Example of occupational data added to observation measure |
| [Observation example](Observation-example.md) | Example of Decreased Hemoglobin Observation |
| [Organization example](Organization-example.md) | HL7 Organization example |
| [PHQ-9 QuestionnaireResponse Example](QuestionnaireResponse-PHQ-9-example.md) | Example of a PHQ-9 Questionnaire Response |
| [Patient example](Patient-example.md) | Basic Patient example |
| [Practitioner example](Practitioner-example.md) | Referring Practitioner example |
| [PractitionerRole example](PractitionerRole-example.md) | PractitionerRole example |
| [Procedure general example](Procedure-example.md) | Appendectomy Procedure example (using the General Profile) |
| [Procedure positive example](Procedure-done-example.md) | Appendectomy Procedure example (using the Positive Profile) |
| [ProcedureNotDone with code example](Procedure-negation-with-code-example.md) | Example of procedure not done using a code |
| [ProcedureNotDone with value set example](Procedure-negation-example.md) | Example of procedure not done using a value set |
| [QICore ModelInfo Settings example](Parameters-qicore-modelinfosettings.md) | QICore ModelInfo Settings Example |
| [RelatedPerson example](RelatedPerson-example.md) | Emergency contact example |
| [ServiceProhibited with code example](ServiceRequest-negation-example-code.md) | Example of request not to provide a service using a code |
| [ServiceProhibited with value set example](ServiceRequest-negation-example.md) | Example of request not to provide a service using a value set |
| [ServiceRequest Myringotomy Procedure example](ServiceRequest-myringotomy-example.md) | ServiceRequest for Myringotomy Procedure example |
| [ServiceRequest appropriateness example](ServiceRequest-appropriateness-example.md) | ServiceRequest appropriateness example |
| [ServiceRequest elective example](ServiceRequest-elective-example.md) | Elective procedure ServiceRequest example |
| [ServiceRequest general example](ServiceRequest-example.md) | Request for Appendectomy ServiceRequest example (using the General Profile) |
| [ServiceRequest positive example with a code](ServiceRequest-proposal-example-code.md) | Request for Graduated compression elastic hosiery using a code example (using the Positive Profile) |
| [ServiceRequest positive example with a value set](ServiceRequest-proposal-example.md) | Request for Intermittent pneumatic compression devices using a value set example (using the Positive Profile) |
| [ServiceRequested appendix example](ServiceRequest-servicerequested-example.md) | Appendectomy ServiceRequested example |
| [Substance example](Substance-example.md) | Honey Bee venom (apitoxin) Substance example |
| [Task general example](Task-example.md) | Task example (using the General Profile) |
| [Task positive example](Task-done-example.md) | Task example (using the Positive Profile) |
| [TaskRejected example rejecting a proposal using a code](Task-rejected-with-code-example.md) | Example of a task rejecting a proposal that identifies the requested activity with a code |
| [TaskRejected example rejecting a proposal using a value set](Task-rejected-example.md) | Example of a task rejecting a proposal that identifies the requested activity with a value set |
| [TaskRejected with code example](Task-negation-with-code-example.md) | Example of task not done using a code |
| [TaskRejected with value set example](Task-negation-example.md) | Example of task not done using a value set |

