# Positive Task Status - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Positive Task Status**

## ValueSet: Positive Task Status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-task-status | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:PositiveTaskStatus |

 
This value set defines the set of codes that indicate a positive task status 

 
This value set was defined to support the set of task statuses in FHIR that indicate a positive status. 

 **References** 

* [QICore Task Done](StructureDefinition-qicore-taskdone.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-task-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-task-status",
  "version" : "7.0.2",
  "name" : "PositiveTaskStatus",
  "title" : "Positive Task Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive task status",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of task statuses in FHIR that indicate a positive status.",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/task-status",
        "concept" : [
          {
            "code" : "draft",
            "display" : "Draft"
          },
          {
            "code" : "requested",
            "display" : "Requested"
          },
          {
            "code" : "received",
            "display" : "Received"
          },
          {
            "code" : "accepted",
            "display" : "Accepted"
          },
          {
            "code" : "ready",
            "display" : "Ready"
          },
          {
            "code" : "in-progress",
            "display" : "In Progress"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          }
        ]
      }
    ]
  }
}

```
