# Positive MedicationAdministration Status - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Positive MedicationAdministration Status**

## ValueSet: Positive MedicationAdministration Status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medication-admin-status | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:PositiveMedicationAdministrationStatus |

 
This value set defines the set of codes that indicate a positive medication administration status (i.e. codes that indicate at least some medication is being or was administered) 

 
This value set was defined to support the set of medication administration statuses in FHIR that indicate a positive status (i.e. all the codes from the http://terminology.hl7.org/CodeSystem/medication-admin-status code system that indicate at least some medication is being or was administered). 

 **References** 

* [QICore MedicationAdministration Done](StructureDefinition-qicore-medicationadministrationdone.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-medication-admin-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medication-admin-status",
  "version" : "7.0.2",
  "name" : "PositiveMedicationAdministrationStatus",
  "title" : "Positive MedicationAdministration Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive medication administration status (i.e. codes that indicate at least some medication is being or was administered)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of medication administration statuses in FHIR that indicate a positive status (i.e. all the codes from the http://terminology.hl7.org/CodeSystem/medication-admin-status code system that indicate at least some medication is being or was administered).",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-admin-status",
        "concept" : [
          {
            "code" : "in-progress",
            "display" : "In Progress"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          },
          {
            "code" : "stopped",
            "display" : "Stopped"
          }
        ]
      }
    ]
  }
}

```
