# TaskRejected with code example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TaskRejected with code example**

## Example Task: TaskRejected with code example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)

**identifier**: `http://www.acme.org/tasks`/19009

**status**: Rejected

**statusReason**: Patient noncompliance - general (situation)

**intent**: proposal

**code**: Medication reconciliation (procedure)

**focus**: [Procedure Excision of appendix (procedure)](Procedure-example.md)

**for**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**executionPeriod**: 2018-06-11 --> 2018-06-11



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "negation-with-code-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/tasks",
      "value" : "19009"
    }
  ],
  "status" : "rejected",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "275936005",
        "display" : "Patient noncompliance - general (situation)"
      }
    ]
  },
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "430193006",
        "display" : "Medication reconciliation (procedure)"
      }
    ]
  },
  "focus" : {
    "reference" : "Procedure/example"
  },
  "for" : {
    "reference" : "Patient/example"
  },
  "executionPeriod" : {
    "start" : "2018-06-11",
    "end" : "2018-06-11"
  }
}

```
