# Task positive example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task positive example**

## Example Task: Task positive example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Task Done](StructureDefinition-qicore-taskdone.md)

**identifier**: `http://www.acme.org/tasks`/19009

**status**: Completed

**intent**: proposal

**priority**: Routine

**code**: Medication Reconciliation

**for**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**executionPeriod**: 2018-06-11 --> 2018-06-11



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "done-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskdone"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/tasks",
      "value" : "19009"
    }
  ],
  "status" : "completed",
  "intent" : "proposal",
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "code" : "99483"
      }
    ],
    "text" : "Medication Reconciliation"
  },
  "for" : {
    "reference" : "Patient/example"
  },
  "executionPeriod" : {
    "start" : "2018-06-11",
    "end" : "2018-06-11"
  }
}

```
