# Substance example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance example**

## Example Substance: Substance example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Substance](StructureDefinition-qicore-substance.md)

**identifier**: `http://acme.org/identifiers/substances`/1463

**status**: Active

**category**: Allergen

**code**: apitoxin (Honey Bee Venom)

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Quantity** | **Substance[x]** |
| * | 0.150 mg/1 | [Substance](Substance-example.md) |



## Resource Content

```json
{
  "resourceType" : "Substance",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-substance"
    ]
  },
  "identifier" : [
    {
      "system" : "http://acme.org/identifiers/substances",
      "value" : "1463"
    }
  ],
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/substance-category",
          "code" : "allergen",
          "display" : "Allergen"
        }
      ]
    }
  ],
  "code" : {
    "text" : "apitoxin (Honey Bee Venom)"
  },
  "ingredient" : [
    {
      "quantity" : {
        "numerator" : {
          "value" : 0.150,
          "unit" : "mg"
        },
        "denominator" : {
          "value" : 1
        }
      },
      "substanceReference" : {
        "reference" : "Substance/example"
      }
    }
  ]
}

```
